# -*- coding: utf-8 -*-

import logging
import xml.etree.ElementTree as etree


DEFAULT_CONFIG = """<?xml version="1.0" encoding="UTF-8"?>
<config>
    <serverconfig>
        <ip>0.0.0.0</ip>
        <accesslog>STDOUT</accesslog>
        <syslog>voice-server.syslog</syslog>
        <loglevel>DEBUG</loglevel>
        <workertype>thread</workertype>
        <maxconnection>100</maxconnection>
    </serverconfig>
</config>"""


def generate_voice_server_config(config_path, base_config_path, config_params):
    """ генерируем конфиг для voice-server-а в файл config_path
        из базового (если предоставлен) и (пере)определённых параметров
    """
    if base_config_path:
        xml = etree.parse(base_config_path)
    else:
        xml = etree.ElementTree(etree.fromstring(DEFAULT_CONFIG))

    def _update_cfg_param(xml, name, value):
        'change exist param or add new if need'
        logging.debug('update server config param {}={}'.format(name, value))
        conf = xml.getroot().getchildren()[0]
        param = conf.find(name)
        if param is not None:
            param.text = value
        else:
            elem = etree.Element(name)
            elem.text = value
            conf.append(elem)

    for name, value in config_params.iteritems():
        _update_cfg_param(xml, name, value)

    xml.write(config_path)
