import sandbox.common.types.client as ctc
import sandbox.projects.common.constants as consts
import sandbox.projects.release_machine.mixins.build as rm_build_mixin
import sandbox.projects.common.search.gdb as gdb

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.release_machine import rm_notify

from sandbox.projects.voicetech.resource_types import ALICE_GPROXY_BINARY


@rm_notify.notify2()
class BuildGproxy(rm_build_mixin.ComponentReleaseTemplate, CommonBuildTask, nanny.ReleaseToNannyTask):
    """ Build cachalot component
    """

    type = 'BUILD_GPROXY'
    execution_space = 80000  # 80 Gb
    input_parameters = CommonBuildTask.input_parameters
    client_tags = ctc.Tag.Group.LINUX
    TARGET_RESOURCE_TYPES = (
        ALICE_GPROXY_BINARY,
    )

    def on_enqueue(self):
        if '/trunk/' in self.ctx[consts.ARCADIA_URL_KEY]:
            self.execution_space = min(50 * 1024, self.execution_space)  # Decrease trunk build execution space
        CommonBuildTask.on_enqueue(self)

    def do_execute(self):
        # Not add gdb to trunk builds
        if '/trunk/' not in self.ctx.get(consts.ARCADIA_URL_KEY, ''):
            gdb.append_to_release(self)
        CommonBuildTask.do_execute(self)

    def on_release(self, additional_parameters):
        # FIXME(mvel) a bit of copypaste here
        if nanny.STARTREK_TICKET_IDS_KEY in additional_parameters:
            self.ctx[nanny.STARTREK_TICKET_IDS_KEY] = additional_parameters[nanny.STARTREK_TICKET_IDS_KEY]

        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = BuildGproxy
