# -*- coding: utf-8 -*-
from sandbox import sdk2

AbstractResource = sdk2.resource.AbstractResource


class VOICETECH_DATA(sdk2.Resource):
    """
        Yaldi lingware end-of-utterance data
    """
    auto_backup = True
    executable = False
    any_arch = True
    calc_md5 = True
    releasers = ["VOICESERV_RELEASERS"]
    releasable = True


class VOICETECH_PACKAGE(VOICETECH_DATA):
    """
        Voicetech's package
    """
    any_arch = False
    package_mode = "raw"  # or "tar" or "targz"
    package_path = None  # must be defined in subclasses


class VOICETECH_TTS_NORMALIZER_DATA(VOICETECH_DATA):
    """
        All supported langs normalizer data models (sets *.fst files)
    """
    pass


class VOICETECH_YALDI_EOU_DATA(VOICETECH_DATA):
    """
        Yaldi lingware end-of-utterance data
    """
    pass


class VOICETECH_LINGWARE(VOICETECH_DATA):
    """
       Voicetech base lingware class
    """
    pass


class VOICETECH_TTS_LINGWARE(VOICETECH_LINGWARE):
    pass


class VOICETECH_TTS_RU_US(VOICETECH_TTS_LINGWARE):
    pass


class VOICETECH_TTS_RU_GPU(VOICETECH_TTS_LINGWARE):
    arcadia_build_path = 'voicetech/tts/lingware/src/ru_e2e'
    lang = 'ru'


class VOICETECH_TTS_RU_MULTISPEAKER_GPU(VOICETECH_TTS_LINGWARE):
    arcadia_build_path = 'voicetech/tts/lingware/src/ru_multispeaker_e2e'
    lang = 'ru'


class VOICETECH_TTS_RU_VALTZ_GPU(VOICETECH_TTS_LINGWARE):
    arcadia_build_path = 'voicetech/tts/lingware/src/ru_valtz_e2e'
    lang = 'ru'


class VOICETECH_TTS_RU(VOICETECH_TTS_LINGWARE):
    arcadia_build_path = 'voicetech/tts/lingware/src/ru_para'
    lang = 'ru'


class VOICETECH_TTS_TR_GPU(VOICETECH_TTS_LINGWARE):
    arcadia_build_path = 'voicetech/tts/lingware/src/tr_e2e'
    lang = 'tr'


class VOICETECH_TTS_RU_FASTDATA(VOICETECH_DATA):
    arcadia_build_path = 'voicetech/tts/lingware/src/ru_fastdata'
    revision = sdk2.Attributes.String("Arc revision", required=True)
    version = sdk2.Attributes.Integer('Version', required=True)


class VOICETECH_TTS_RU_FASTDATA_BUNDLE(VOICETECH_DATA):
    """
    gzip with TTS server fast data
    """
    revision = sdk2.Attributes.String("Arc revision", required=True)
    version = sdk2.Attributes.Integer('Version', required=True)


class VOICETECH_YALDI_LINGWARE(VOICETECH_LINGWARE):
    """
        Yaldi lingware end-of-utterance data
    """
    releasable = False


class VOICETECH_YALDI_RU_RU_DIALOGMAPS(VOICETECH_LINGWARE):
    """
        Yaldi lingware ru-ru-dialogmaps
    """
    pass


class VOICETECH_ASR_TEST_LINGWARE(VOICETECH_LINGWARE):
    """
        Yaldi lingware end-of-utterance data
    """
    arcadia_build_path = 'voicetech/asr/lingware/test_lingware'


class VOICETECH_ASR_MULTITOPIC_RU_RU_DIALOGMAPSGPU_TR_TR_DIALOGMAPSGPU(VOICETECH_LINGWARE):
    """
        asr-server lingware multitopic ru-ru-dialogmapsgpu && tr-tr-dialogmapsgpu
    """
    arcadia_build_path = 'voicetech/asr/lingware/multitopic_ru_tr_dialog_maps_e2e'


class VOICETECH_YALDI_RU_RU_DIALOGENERALFAST(VOICETECH_LINGWARE):
    """
        Yaldi lingware ru-ru-dialogeneralfast
    """
    pass


class VOICETECH_YALDI_RU_RU_DIALOGENERALGPU(VOICETECH_LINGWARE):
    """
        Yaldi lingware ru-ru-dialogeneralgpu
    """
    pass


class VOICETECH_YALDI_RU_RU_QUASARGENERAL(VOICETECH_LINGWARE):
    """
        Yaldi lingware ru-ru-quasargeneral
    """
    pass


class VOICETECH_ASR_RU_RU_DIALOGENERALGPU(VOICETECH_LINGWARE):
    """
        asr-server lingware ru-ru-dialogeneralgpu
    """
    arcadia_build_path = 'voicetech/asr/lingware/ru_dialog_general_e2e'


class VOICETECH_ASR_RU_RU_CHATSGPU(VOICETECH_LINGWARE):
    """
        asr-server lingware ru-ru-chats
    """
    arcadia_build_path = 'voicetech/asr/lingware/ru_chats_e2e'


class VOICETECH_ASR_RU_RU_CHATSGPU_V2(VOICETECH_LINGWARE):
    """
        asr-server lingware ru-ru-chats-v2
    """
    arcadia_build_path = 'voicetech/asr/lingware/ru_chats_e2e_v2'


class VOICETECH_ASR_RU_RU_QUASARGENERALGPU(VOICETECH_LINGWARE):
    """
        asr-server lingware ru-ru-quasargeneralgpu
    """
    arcadia_build_path = 'voicetech/asr/lingware/ru_quasar_general_e2e'


class VOICETECH_ASR_INTL_QUASARGENERALGPU(VOICETECH_LINGWARE):
    """
        asr-server lingware for international
    """
    arcadia_build_path = 'voicetech/asr/lingware/ar_quasar_general_e2e'


class VOICETECH_ASR_RU_RU_TVGENERALGPU(VOICETECH_LINGWARE):
    """
        asr-server lingware ru-ru-tvgeneralgpu
    """
    arcadia_build_path = 'voicetech/asr/lingware/ru_tv_general_e2e'


class VOICETECH_ASR_MULTITOPIC_RU_RU_QUASARGENERALGPU_RU_RU_TVGENERALGPU(VOICETECH_LINGWARE):
    """
        asr-server lingware multitopic ru-ru-quasargeneralgpu && ru-ru-tvgeneralgpu
    """
    arcadia_build_path = 'voicetech/asr/lingware/multitopic_ru_quasar_tv_e2e'


class VOICETECH_ASR_MULTITOPIC_CHATS(VOICETECH_LINGWARE):
    """
        asr-server lingware multitopic chats
    """
    arcadia_build_path = 'voicetech/asr/lingware/multitopic_chats_e2e'


class VOICETECH_ASR_ZEN_MULTILANG_VIDEO(VOICETECH_LINGWARE):
    """
        v2v multilang lingware
    """
    arcadia_build_path = 'voicetech/asr/zen/lingware/multilang_video_quality'
    zen = True


class VOICETECH_BIO_QUASAR(VOICETECH_LINGWARE):
    """
        asr-server lingware ru-ru-dialogeneralgpu
    """
    arcadia_build_path = 'voicetech/bio/lingware/quasar'


class VOICETECH_ASR_RU_RU_MINIQUASARGENERALGPU(VOICETECH_LINGWARE):
    """
        asr-server lingware ru-ru-miniquasargeneralgpu
    """
    pass


class VOICETECH_YALDI_RU_RU_QUASARSPOTTERCHECK(VOICETECH_LINGWARE):
    """
        Yaldi lingware ru-ru-quasarspottercheck
    """
    pass


class VOICETECH_YALDI_RU_RU_SRGS(VOICETECH_LINGWARE):
    """
        Yaldi lingware ru-ru-srgs
    """
    pass


class VOICETECH_YALDI_RU_RU_SPRAV_DATETIME(VOICETECH_LINGWARE):
    """
        Yaldi lingware ru-ru-sprav-datetime
    """
    pass


class VOICETECH_YALDI_UK_UA_MAPS(VOICETECH_LINGWARE):
    """
        Yaldi lingware uk-ua-maps
    """
    pass


class VOICETECH_YALDI_TR_TR_MAPS(VOICETECH_LINGWARE):
    """
        Yaldi lingware tr-tr-maps
    """
    pass


class VOICETECH_YALDI_REVERSE_NORMALIZER_DATA(VOICETECH_DATA):
    """
        Yaldi reverse normalizer
    """
    pass


class VOICETECH_UNIPROXY_EXPERIMENTS(VOICETECH_DATA):
    """
        Experiments configuration for uniproxy
    """
    pass


class VOICETECH_UNIPROXY_FUNC_TESTS_DATA(VOICETECH_DATA):
    """
        Data for functional testing uniproxy
    """
    pass


class VOICETECH_UNIPROXY_PERF_TESTER_RESULT(VOICETECH_DATA):
    """
        VOICETECH_UNIPROXY_PERF_TESTER_EXE execution result (JSON)
    """
    perf_process_id = sdk2.Attributes.String("task-generator process_id parameter", default='unknown')


class VOICETECH_UNIPROXY_PERF_TESTER_RESULT_STAT(VOICETECH_DATA):
    """
        statistics extracted from VOICETECH_UNIPROXY_PERF_TESTER_EXE execution result (JSON)
    """
    perf_process_id = sdk2.Attributes.String("task-generator process_id parameter", default='unknown')


class VOICETECH_PROGRAM(sdk2.Resource):
    executable = True
    calc_md5 = True
    releasers = ["VOICESERV_RELEASERS"]
    releasable = True


class VOICETECH_UNIPROXY_FUNC_TESTS_EXE(VOICETECH_PROGRAM):
    """
        Program for functional testing uniproxy
    """
    arcadia_build_path = 'voicetech/infra/uniproxy/tests/ftest/ftest'


class VOICETECH_UNIPROXY_PERF_TESTER_EXE(VOICETECH_PROGRAM):
    """
        Program for perfomance testing uniproxy
    """
    arcadia_build_path = 'alice/uniproxy/tools/perf_tester/perf_tester'


class VOICETECH_SERVER(VOICETECH_PROGRAM):
    pass


class VOICETECH_EVLOGDUMP(VOICETECH_PROGRAM):
    arcadia_build_path = 'alice/rtlog/evlogdump/evlogdump'


class VOICETECH_YALDI_SERVER(VOICETECH_SERVER):
    """
        Yaldi server executable (folder yaldi-server/ contain yaldi-server + *.so files)
    """
    pass


class VOICETECH_ASR_SERVER(VOICETECH_SERVER):
    """
        Asr server executable
    """
    arcadia_build_path = 'voicetech/asr/server/asr-server'


class VOICETECH_ASR_SERVER_GPU(VOICETECH_SERVER):
    """
        Asr server with CUDA executable
    """
    arcadia_build_path = 'voicetech/asr/server/asr-server'


class VOICETECH_ASR_SERVER_RUNNER(VOICETECH_SERVER):
    """
        bash script for run asr-server
    """
    arcadia_build_path = 'voicetech/asr/server/runner/run.sh'


class VOICETECH_ASR_NN_SERVER(VOICETECH_SERVER):
    """
        asr nn server executable
    """
    arcadia_build_path = 'voicetech/asr/nn_server/bin/nn_server/nn_server'


class VOICETECH_ASR_NN_SERVER_GPU(VOICETECH_SERVER):
    """
        asr nn server with CUDA executable
    """
    arcadia_build_path = 'voicetech/asr/nn_server/bin/nn_server/nn_server'


class VOICETECH_ASR_NN_SERVER_RUNNER(VOICETECH_SERVER):
    """
        bash script for run nn-server
    """
    arcadia_build_path = 'voicetech/asr/nn_server/bin/nn_server/runner/run.sh'


class VOICETECH_BIO_SERVER(VOICETECH_SERVER):
    """
        Bio server executable
    """
    arcadia_build_path = 'voicetech/asr/server/asr-server'


class VOICETECH_BIO_SERVER_RUNNER(VOICETECH_SERVER):
    """
        bash script for run asr-server
    """
    arcadia_build_path = 'voicetech/bio/server_runner/run.sh'


class VOICETECH_YABIO_SERVER(VOICETECH_SERVER):
    """
        Yabio server executable (folder yabio-server/ contain yabio-server + *.so files)
    """
    pass


class VOICETECH_TTS_SERVER(VOICETECH_SERVER):
    """
        Tts server executable
    """
    arcadia_build_path = 'voicetech/tts/server/tts-server'


class VOICETECH_TTS_SERVER_GPU(VOICETECH_SERVER):
    """
        Tts server with CUDA executable
    """
    arcadia_build_path = 'voicetech/tts/server/tts-server'


class VOICETECH_TTS_SERVER_RUNNER(VOICETECH_SERVER):
    """
        bash script for run tts-server
    """
    arcadia_build_path = 'voicetech/tts/server/runner/run.sh'


class VOICETECH_TTS_FASTDATA_SMOKE_TEST(VOICETECH_PROGRAM):
    """
    Smoke test to check if tts fast data is valid
    """
    arcadia_build_path = 'voicetech/tts/fast_data/smoke_test/fastdata_smoke_test'


class VOICETECH_TTS_FASTDATA_SMOKE_TEST_CASES(VOICETECH_DATA):
    """
    Texts for tts fast data smoke test
    """
    arcadia_build_path = 'voicetech/tts/fast_data/smoke_test/data/fast_data_test_cases.json'


class VOICETECH_SERVER_CONFIG(sdk2.Resource):
    auto_backup = True
    any_arch = True
    executable = False
    calc_md5 = True
    releasers = ["VOICESERV_RELEASERS"]
    releasable = True


class VOICETECH_ASR_SERVER_CONFIG(VOICETECH_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_RU_RU_DIALOGENERALGPU_CONFIG(VOICETECH_ASR_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_RU_RU_CHATSGPU_CONFIG(VOICETECH_ASR_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_RU_RU_QUASARGENERALGPU_CONFIG(VOICETECH_ASR_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_RU_RU_TVGENERALGPU_CONFIG(VOICETECH_ASR_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_MULTITOPIC_RU_RU_QUASARGENERALGPU_TVGENERALGPU_CONFIG(VOICETECH_ASR_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_MULTITOPIC_RU_TR_DIALOGMAPSGPU_CONFIG(VOICETECH_ASR_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_BIO_QUASAR_CONFIG(VOICETECH_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_MIXED_RUNNER_GLOBAL_CONFIG(VOICETECH_ASR_SERVER_CONFIG):
    pass


class VOICETECH_ASR_SERVER_RU_RU_QUASARGENERALGPU_MRGC(VOICETECH_ASR_SERVER_MIXED_RUNNER_GLOBAL_CONFIG):
    pass


class VOICETECH_ASR_NN_SERVER_CONFIG(VOICETECH_ASR_SERVER_CONFIG):
    pass


class VOICETECH_ASR_NN_SERVER_RU_RU_QUASARGENERALGPU_CONFIG(VOICETECH_ASR_NN_SERVER_CONFIG):
    pass


class VOICETECH_SERVER_REVERSE_NORMALIZER_DATA(VOICETECH_DATA):
    arcadia_build_path = 'voicetech/asr/normalizer'


class VOICETECH_SERVER_PUNCTUATION_DATA(VOICETECH_DATA):
    arcadia_build_path = 'voicetech/asr/punctuation'


class VOICETECH_SERVER_BIOMETRY_DATA(VOICETECH_DATA):
    pass


class VOICETECH_ASR_SERVER_SANITY_JOBS(sdk2.Resource):
    auto_backup = True
    any_arch = True
    executable = False
    calc_md5 = True
    releasable = False


class VOICETECH_UNIPROXY_SUBWAY(VOICETECH_PROGRAM):
    """
        uniproxy-subway server
    """
    arcadia_build_path = 'alice/uniproxy/bin/uniproxy-subway/uniproxy-subway'


class VOICETECH_UNIPROXY_BINARY(VOICETECH_PROGRAM):
    """
        uniproxy server
    """
    arcadia_build_path = 'alice/uniproxy/bin/uniproxy/uniproxy'


class VOICETECH_UNIPROXY_DELIVERY(VOICETECH_PROGRAM):
    """
        uniproxy-delivery server
    """
    arcadia_build_path = 'alice/uniproxy/bin/uniproxy-delivery/uniproxy-delivery'


class VOICETECH_NOTIFICATOR(VOICETECH_PROGRAM):
    """
        notificator server
    """
    arcadia_build_path = 'alice/uniproxy/bin/notificator/notificator'


class VOICETECH_UNIPROXY_PACKAGE(VOICETECH_PACKAGE):
    """
        uniproxy&subway package to be used in RTC
    """
    package_path = 'alice/uniproxy/rtc/uniproxy-package.json'


class VOICETECH_CUTTLEFISH_PACKAGE(VOICETECH_PACKAGE):
    """
        cuttlefish package to be used in RTC
    """
    package_path = 'alice/cuttlefish/cuttlefish-package.json'


class VOICETECH_UNIPROXY_FTEST_PACKAGE(VOICETECH_PACKAGE):
    """
        uniproxy ftest (binary & sessions)
    """
    package_path = 'voicetech/infra/uniproxy/tests/ftest/package.json'


class VOICETECH_CACHALOT_CONFIGS(VOICETECH_PACKAGE):
    """
        cachalot configs and scripts for running in yp/rtc
    """
    pass


class VOICETECH_UNIPROXY_CONFIGS(VOICETECH_PACKAGE):
    """
        uniproxy configs and scripts for running in yp/rtc
    """
    pass


class VOICETECH_CUTTLEFISH_CONFIGS(VOICETECH_PACKAGE):
    """
        cuttlefish configs and scripts for running in yp/rtc
    """
    pass


class VOICETECH_APPHOST_CONFIGS(VOICETECH_PACKAGE):
    """
        apphost configs and scripts for running in yp/rtc
    """
    pass


class VOICETECH_UNIPROXY_BETA_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        uniproxy configs and scripts for running in yp/rtc beta installation
    """
    pass


class VOICETECH_CUTTLEFISH_BETA_CONFIGS(VOICETECH_CUTTLEFISH_CONFIGS):
    """
        cuttlefish configs and scripts for running in yp/rtc beta installation
    """
    pass


class VOICETECH_APPHOST_BETA_CONFIGS(VOICETECH_APPHOST_CONFIGS):
    """
        apphost configs and scripts for running in yp/rtc beta installation
    """
    pass


class VOICETECH_UNIPROXY_QUASAR_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        uniproxy configs and scripts for running in yp/rtc quasar installation
    """
    pass


class VOICETECH_CUTTLEFISH_QUASAR_CONFIGS(VOICETECH_CUTTLEFISH_CONFIGS):
    """
        cuttlefish configs and scripts for running in yp/rtc quasar installation
    """
    pass


class VOICETECH_APPHOST_QUASAR_CONFIGS(VOICETECH_APPHOST_CONFIGS):
    """
        apphost configs and scripts for running in yp/rtc quasar installation
    """
    pass


class VOICETECH_UNIPROXY_FETCH_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        uniproxy configs and scripts for running in yp/rtc fetch installation
    """
    pass


class VOICETECH_CUTTLEFISH_FETCH_CONFIGS(VOICETECH_CUTTLEFISH_CONFIGS):
    """
        cuttlefish configs and scripts for running in yp/rtc fetch installation
    """
    pass


class VOICETECH_APPHOST_FETCH_CONFIGS(VOICETECH_APPHOST_CONFIGS):
    """
        apphost configs and scripts for running in yp/rtc fetch installation
    """
    pass


class VOICETECH_UNIPROXY_EVENTS_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        uniproxy configs and scripts for running in yp/rtc events installation
    """
    pass


class VOICETECH_CUTTLEFISH_EVENTS_CONFIGS(VOICETECH_CUTTLEFISH_CONFIGS):
    """
        cuttlefish configs and scripts for running in yp/rtc events installation
    """
    pass


class VOICETECH_APPHOST_EVENTS_CONFIGS(VOICETECH_APPHOST_CONFIGS):
    """
        apphost configs and scripts for running in yp/rtc events installation
    """
    pass


class VOICETECH_UNIPROXY_LEGACY_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        uniproxy configs and scripts for running in yp/rtc legacy installation
    """
    pass


class VOICETECH_CUTTLEFISH_LEGACY_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        cuttlefish configs and scripts for running in yp/rtc legacy installation
    """
    pass


class VOICETECH_APPHOST_LEGACY_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        apphost configs and scripts for running in yp/rtc legacy installation
    """
    pass


class VOICETECH_UNIPROXY_MESSENGER_CONFIGS(VOICETECH_PACKAGE):
    """
        messenger uniproxy configs and scripts for running in yp/rtc
    """
    pass


class VOICETECH_SPEECHBASE_BINARY(VOICETECH_PACKAGE):
    """
        speechbase web server package
    """
    package_path = "voicetech/infra/speechbase_web/rtc-package.json"


class VOICETECH_AUTHPROXY_BINARY(VOICETECH_PACKAGE):
    """
        authproxy package
    """
    package_path = "voicetech/infra/authproxy/rtc-package.json"


class VOICETECH_LEGACY_VOICEPROXY_LOG_INSPECTOR_BINARY(VOICETECH_PACKAGE):
    """
        legacy_voiceproxy_log_inspector package
    """
    package_path = "voicetech/infra/log_inspectors/legacy_voiceproxy/rtc-package.json"


class VOICETECH_CUTTLEFISH_BINARY(VOICETECH_PROGRAM):
    """
        cuttlefish binary (AppHost'ed uniproxy)
    """
    arcadia_build_path = 'alice/cuttlefish/bin/cuttlefish/cuttlefish'


class VOICETECH_CACHALOT_BINARY(VOICETECH_PROGRAM):
    """
        tts & bio & context cache binary (neh + apphost)
    """
    arcadia_build_path = 'alice/cachalot/bin/cachalot'


class ALICE_GPROXY_BINARY(VOICETECH_PROGRAM):
    """
        Alice GRPC Fetch Proxy
    """
    arcadia_build_path = 'alice/gproxy/bin/gproxy/gproxy'
    releasers = ["VOICESERV_RELEASERS", "akormushkin"]


class ALICE_GPROXY_SETUP_BINARY(VOICETECH_PROGRAM):
    """
        Alice GRPC Fetch Proxy Servant
    """
    arcadia_build_path = 'alice/gproxy/bin/gproxy-setup/gproxy-setup'
    releasers = ["VOICESERV_RELEASERS", "akormushkin"]


class ALICE_GPROXY_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        Alice GRPC Fetch proxy configs
    """
    pass


class ALICE_GPROXY_SETUP_CONFIGS(VOICETECH_UNIPROXY_CONFIGS):
    """
        Alice GRPC Fetch proxy servant configs
    """
    pass


class QUASAR_FACTORIO_BINARY(VOICETECH_PROGRAM):
    """
        Entry point for factories' infrastructure
    """
    arcadia_build_path = 'quasar/manufacturing/factorio/bin/factorio'


class QUASAR_FACTORIO_SERVANT_BINARY(VOICETECH_PROGRAM):
    """
        Factorio AppHost servant
    """
    arcadia_build_path = 'quasar/manufacturing/factorio/bin/servant'


class ALICE_FDSTATSRV_BINARY(VOICETECH_PROGRAM):
    """
        File Descriptor Stat Tool for YASM
    """
    arcadia_build_path = 'alice/cuttlefish/tools/fdstatsrv'


class VOICETECH_UNILOGVIEWER_DEAMON_BINARY(VOICETECH_PROGRAM):
    arcadia_build_path = 'voicetech/infra/unilogviewer/unilogviewer/unilogviewer'


class VOICETECH_MEMCACHED_YASM_PROXY(VOICETECH_PROGRAM):
    """
        memcached yasm proxy
    """
    arcadia_build_path = 'voicetech/infra/docker/memcached-yasm-proxy/memcached-yasm-proxy'


class VOICETECH_NET_STAT_SERVER(VOICETECH_PROGRAM):
    arcadia_build_path = 'voicetech/infra/junk/net_stat/voicetech/infra/junk/net_stat'


class VOICETECH_GPU_STAT_SERVER(VOICETECH_PROGRAM):
    arcadia_build_path = 'voicetech/infra/gpu_stat'


class VOICETECH_SESSIONLOG_PARSER_BINARY(VOICETECH_PROGRAM):
    arcadia_build_path = 'voicetech/infra/qa/uniproxy-sessionlog-parser'


class VOICETECH_QLOUD_FORMAT_PARSER_BINARY(VOICETECH_PROGRAM):
    arcadia_build_path = 'alice/tools/qloud_format'


class VOICETECH_VOICEPROXY_PARSER_BINARY(VOICETECH_PROGRAM):
    arcadia_build_path = 'voicetech/infra/log_parsers/voiceproxy'


class VOICETECH_TTSPROXY_PARSER_BINARY(VOICETECH_PROGRAM):
    arcadia_build_path = 'voicetech/infra/log_parsers/ttsproxy'


class VOICETECH_VINS_MARKUP_PARSER_BINARY(VOICETECH_PROGRAM):
    arcadia_build_path = 'voicetech/infra/log_parsers/vins_markup'


class VOICETECH_CONTAINER_DEPLOY_BUNDLE(VOICETECH_DATA):
    """
        common tools to bring into container
    """
    releasable = True


class VOICETECH_UDF(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = ["VOICESERV_RELEASERS"]
    releasable = True


class PORTO_LAYER_VOICETECH_UNIPROXY(sdk2.Resource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["VOICESERV_RELEASERS"]


class PORTO_LAYER_VOICETECH_MEMCACHED(sdk2.Resource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["VOICESERV_RELEASERS"]


class PORTO_LAYER_VOICETECH_REDIS(sdk2.Resource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["VOICESERV_RELEASERS"]


class PORTO_LAYER_VOICETECH_SPEECHBASE(sdk2.Resource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["VOICESERV_RELEASERS"]


class ALICE_MARKER_TESTS_CONFIG(sdk2.Resource):
    # VOICESERV-2965
    # examples: alice/acceptance/cli/marker_tests/configs
    auto_backup = True
    calc_md5 = True
    releasable = True
    releasers = ["VOICESERV_RELEASERS"]


class ALICE_MARKER_TESTS_EXE(sdk2.Resource):
    # VOICESERV-2965
    arcadia_build_path = 'alice/acceptance/cli/marker_tests/bin/marker_tests'
    auto_backup = True
    executable = True
    any_arch = False
    calc_md5 = True
    releasable = True
    releasers = ["VOICESERV_RELEASERS"]


class ALICE_MARKER_TESTS_DATA(sdk2.Resource):
    # VOICESERV-2965
    # alice/acceptance/cli/marker_tests/data
    auto_backup = True
    any_arch = True
    calc_md5 = True
    releasable = True
    releasers = ["VOICESERV_RELEASERS"]


class ALICE_CUTTLEFISH_ASR_ADAPTER_PACKAGE(VOICETECH_PACKAGE):
    """ asr_adapter exe(s) & config
    """
    package_path = 'alice/cuttlefish/package/asr_adapter/package.json'


class ALICE_CUTTLEFISH_MUSIC_MATCH_ADAPTER_PACKAGE(VOICETECH_PACKAGE):
    """ music_match_adapter exe(s) & config
    """
    package_path = 'alice/cuttlefish/package/music_match_adapter/package.json'


class ALICE_CUTTLEFISH_TTS_ADAPTER_PACKAGE(VOICETECH_PACKAGE):
    """ tts_adapter exe(s) & config
    """
    package_path = 'alice/cuttlefish/package/tts_adapter/package.json'


class ALICE_CUTTLEFISH_CLOUD_SYNTH_PACKAGE(VOICETECH_PACKAGE):
    """ coud_synth (tts_adapter for cloud) exe(s) & config
    """
    package_path = 'alice/cuttlefish/package/cloud_synth/package.json'


class ALICE_CUTTLEFISH_TTS_CACHE_PROXY_PACKAGE(VOICETECH_PACKAGE):
    """ tts_cache_proxy exe(s) & config
    """
    package_path = 'alice/cuttlefish/package/tts_cache_proxy/package.json'


class ALICE_CUTTLEFISH_YABIO_ADAPTER_PACKAGE(VOICETECH_PACKAGE):
    """ yabio_adapter exe(s) & config
    """
    package_path = 'alice/cuttlefish/package/yabio_adapter/package.json'


class ASR_SERVER_TEST_PACKAGE(VOICETECH_PACKAGE):
    """ asr-server test package
    """
    package_path = 'voicetech/asr/packages/test.json'


class ASR_SERVER_DIALOG_GENERAL_PACKAGE(VOICETECH_PACKAGE):
    """ asr-server dialog-general package
    """
    package_path = 'voicetech/asr/packages/dialog.json'


class ASR_SERVER_DIALOG_MAPS_PACKAGE(VOICETECH_PACKAGE):
    """ asr-server dialog-maps package
    """
    package_path = 'voicetech/asr/packages/maps.json'


class ASR_SERVER_TV_GENERAL_PACKAGE(VOICETECH_PACKAGE):
    """ asr-server tv-general package
    """
    package_path = 'voicetech/asr/packages/tv.json'


# ===================================================== #
#                        LEGACY                         #

voicetech_yaldi_releasers = [
    'and42',
    'av-kotikov',
    'robot-voicetechbugs',
    'dolgawin'
]


class VOICETECH_YALDI_MODELS(AbstractResource):
    """
       Voicetech yaldi models test
    """
    releasers = ['duke66']
    release_subscribers = ['duke66']


class VOICETECH_YALDI_RTF_TEST_SETS(AbstractResource):
    """
       Voicetech yaldi model ru-RU numbers
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    ttl = 999


class VOICETECH_YALDI_RU_RU_NUMBERS(AbstractResource):
    """
       Voicetech yaldi model ru-RU numbers
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_YALDI_RU_RU_MAPSYARI(AbstractResource):
    """
       Voicetech yaldi model ru-RU mapsyari
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_YALDI_RU_RU_GENERAL(AbstractResource):
    """
       Voicetech yaldi model ru-RU general
    """
    releasers = ["VOICESERV_RELEASERS"]
    release_subscribers = ["VOICESERV_RELEASERS"]
    releasable = True


class VOICETECH_YALDI_RU_RU_DIALOGENERAL(AbstractResource):
    """
       Voicetech yaldi model ru-RU dialogeneral
    """
    releasers = ["VOICESERV_RELEASERS"]
    release_subscribers = ["VOICESERV_RELEASERS"]
    releasable = True


class VOICETECH_YALDI_RU_RU_YANDEXSTAFF(AbstractResource):
    """
       Voicetech yaldi model ru-RU yandex-staff
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_BUYING(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_DATES(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_EXPERIMENT(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_INSURANCE(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_MAPCLIENTFEEDBACK(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_MAPTALKS(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_NAMES(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_ONTHEFLY(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_SPUN(AbstractResource):
    """
        Voicetech yaldi model ru-RU numbers;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_AUTOLAUNCHER(AbstractResource):
    """
        Voicetech yaldi model ru-RU autolauncher;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_YALDI_RU_RU_LICENSEPLATE(AbstractResource):
    """
        Voicetech yaldi model ru-RU ru-RU-licenseplate;
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_ES_ES_FREEFORM(AbstractResource):
    """
       Voicetech yaldi model es es freeform
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_ES_ES_MAPS(AbstractResource):
    """
       Voicetech yaldi model es es maps
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_DE_DE_MAPS(AbstractResource):
    """
       Voicetech yaldi model de-de maps
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_FREEFORM(AbstractResource):
    """
       Voicetech yaldi model ru-RU freeform
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_YALDI_RU_RU_DESKTOPGENERAL(AbstractResource):
    """
       Voicetech yaldi model ru-RU DESKTOPGENERAL
    """
    releasers = ["VOICESERV_RELEASERS"]
    release_subscribers = ["VOICESERV_RELEASERS"]
    releasable = True


class VOICETECH_YALDI_RU_RU_MUSIC(AbstractResource):
    """
       Voicetech yaldi model ru-RU Music
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_RU_RU_QUESTIONNAIRE(AbstractResource):
    """
       Voicetech yaldi model ru-RU questionnaire
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_EN_EN_FREEFORM(AbstractResource):
    """
        Voicetech yaldi model en-en freeform
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_EN_EN_GENERAL(AbstractResource):
    """
        Voicetech yaldi model en-en general
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_EN_EN_MAPS(AbstractResource):
    """
        Voicetech yaldi model en-en maps
    """
    releasers = voicetech_yaldi_releasers + ["VOICESERV_RELEASERS"]
    release_subscribers = voicetech_yaldi_releasers + ["VOICESERV_RELEASERS"]
    releasable = True


class VOICETECH_YALDI_EN_EN_ONTHEFLY(AbstractResource):
    """
        Voicetech yaldi model en-en onthefly
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_TR_TR_FREEFORM(AbstractResource):
    """
        Voicetech yaldi model tr-tr freeform
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_TR_TR_GENERAL(AbstractResource):
    """
        Voicetech yaldi model tr-tr general
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_TR_TR_MAPSYARI(AbstractResource):
    """
        Voicetech yaldi model tr-tr mapsyari
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_FR_FR_MAPS(AbstractResource):
    """
        Voicetech yaldi model fr-fr maps
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_UK_UA_FREEFORM(AbstractResource):
    """
        Voicetech yaldi model uk-uk freeform
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_UK_UA_GENERAL(AbstractResource):
    """
        Voicetech yaldi model uk-uk general
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_UK_UA_MAPSYARI(AbstractResource):
    """
        Voicetech yaldi model uk-uk mapsyari
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_IT_IT_FREEFORM(AbstractResource):
    """
        Voicetech yaldi model it-it freeform
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_IT_IT_MAPS(AbstractResource):
    """
        Voicetech yaldi model it-it maps
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers


class VOICETECH_YALDI_YABIO(AbstractResource):
    """
       Voicetech yaldi model yabio - gender and age
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_TTS_TR(AbstractResource):
    """
       Voicetech TTS TR
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_TTS_UK(AbstractResource):
    """
       Voicetech TTS UK
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_TTS_EN(AbstractResource):
    """
       Voicetech TTS EN
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_LMSCORING_MODEL(AbstractResource):
    """
       Voicetech lmscoring model (VOICE-3826)
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    releasable = True


class VOICETECH_YALDI_SERVER_DOCKER(AbstractResource):
    """
       Voicetech yaldi server Docker files
    """
    releasers = voicetech_yaldi_releasers
    release_subscribers = voicetech_yaldi_releasers
    auto_backup = True


class VOICETECH_TTS_TEST_DATA(VOICETECH_DATA):
    """
        Textspecs for TTS loadtest
    """


class VOICETECH_TTS_RU_DATA(VOICETECH_TTS_TEST_DATA):
    """Testdata for RU setup"""


class VOICETECH_TTS_RU_DATA_VALTZ(VOICETECH_TTS_TEST_DATA):
    """Testdata for RU setup"""


class VOICETECH_TTS_RU_DATA_OKSANA(VOICETECH_TTS_TEST_DATA):
    """Testdata for RU setup"""


class VOICETECH_TTS_TR_DATA(VOICETECH_TTS_TEST_DATA):
    """Testdata for TR setup"""


class VOICETECH_TTS_CLIENT_EXE(VOICETECH_PROGRAM):
    """
        Program for perfomance testing uniproxy
    """
    arcadia_build_path = 'voicetech/tts/client'


class VOICETECH_TTS_LOADTEST_RESULT(VOICETECH_DATA):
    """
        Loadtest result
    """


class VOICETECH_ASR_STRESS_TEST_RESULT(sdk2.Resource):
    """
        Result of stress (perf) test.
    """
    auto_backup = True
    executable = False
    any_arch = True
    calc_md5 = True
    releasable = True


class VOICETECH_ASR_METRICS_DIFF_TOOL_RESULT(sdk2.Resource):
    """
        Result of voicetech/asr/tools/metrics/metrics_diff_tool.
    """
    pass


class VOICETECH_FAIRSEQ_CHECKPOINT(sdk2.Resource):
    """
        A fairseq checkpoint.
    """
    pass


class VOICETECH_FAIRSEQ_LOGS(sdk2.Resource):
    """
        Training logs for a fairseq checkpoint.
    """
    pass


class VOICETECH_TTC_MODEL(sdk2.Resource):
    """
        Trashtalk Classifier model, output of train_ttc graph.
    """
    pass


class VOICETECH_FAIRSEQ_CONFIG(sdk2.Resource):
    """
        A fairseq training config
    """
    pass

#                        LEGACY                         #
# ===================================================== #
