# coding: U8
beta_deploy_config = {
    "services": {
        "yappy-alice-tts-rm-gpu": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.3,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        }
    },
    "communication": {
        "cluster": "locke",
        "cypress_dir": "//home/voice/tts/fast_data"
    },
    "deploy": {
        "only_prepare": False
    }
}

production_deploy_config = {
    "services": {
        "tts-ru-oksana-gpu-yp-prestable-sas": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.15,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        },
        "tts-ru-oksana-gpu-yp-sas": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.15,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        },
        "tts-ru-oksana-gpu-yp-vla": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.15,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        },
        "tts-ru-gpu-prestable-yp-sas": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.15,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        },
        "tts-ru-gpu-yp-sas": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.15,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        },
        "tts-ru-gpu-yp-vla": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.15,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        },
        "tts-ru-valtz-gpu-yp-sas": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.15,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        },
        "tts-ru-valtz-gpu-yp-vla": {
            "activate": {
                "retry_delay": 300,
                "degrade_level": 0.15,
                "failed_retry_delay": 600,
                "stop_degrade_level": 0.1
            },
            "prepare": {
                "retry_delay": 300,
                "degrade_level": 1,
                "failed_retry_delay": 600
            }
        },
    },
    "communication": {
        "cluster": "locke",
        "cypress_dir": "//home/voice/tts/fast_data"
    },
    "deploy": {
        "only_prepare": False,
        "dependencies": {
            # rollout plan:
            # prepare on valtz
            # prepare on oksana prestable
            # prepare on oksana
            # prepare on shitova prestable
            # prepare on shitova
            # activate on valtz
            # activate on oksana prestable
            # activate on oksana
            # activate on shitova prestable
            # activate on shitova

            # valtz
            "tts-ru-valtz-gpu-yp-sas": {
                # prepare whenever ready
                # activate after tts-ru-gpu-yp-vla prepared
                "activate": [
                    {
                        "action": "prepare",
                        "name": "tts-ru-gpu-yp-vla"
                    }
                ]
            },
            "tts-ru-valtz-gpu-yp-vla": {
                # prepare after tts-ru-valtz-gpu-yp-sas prepared
                # activate after tts-ru-valtz-gpu-yt-sas activated
                "prepare": [
                    {
                        "action": "prepare",
                        "name": "tts-ru-valtz-gpu-yp-sas"
                    }
                ],
                "activate": [
                    {
                        "action": "activate",
                        "name": "tts-ru-valtz-gpu-yp-sas"
                    }
                ]
            },

            # oksana prestable
            "tts-ru-oksana-gpu-yp-prestable-sas": {
                # prepare after tts-ru-valtz-gpu-yp-vla prepared
                # activate after tts-ru-valtz-gpu-yp-vla activated
                "prepare": [
                    {
                        "action": "prepare",
                        "name": "tts-ru-valtz-gpu-yp-vla"
                    }
                ],
                "activate": [
                    {
                        "action": "activate",
                        "name": "tts-ru-valtz-gpu-yp-vla"
                    }
                ],
            },
            # oksana
            "tts-ru-oksana-gpu-yp-sas": {
                # prepare after tts-ru-oksana-gpu-yp-prestable-sas
                # activate after tts-ru-oksana-gpu-yp-prestable-sas
                "prepare": [
                    {
                        "action": "prepare",
                        "name": "tts-ru-oksana-gpu-yp-prestable-sas"
                    }
                ],
                "activate": [
                    {
                        "action": "activate",
                        "name": "tts-ru-oksana-gpu-yp-prestable-sas"
                    }
                ]
            },
            "tts-ru-oksana-gpu-yp-vla": {
                # prepare after tts-ru-oksana-gpu-yp-sas prepared
                # activate after tts-ru-oksana-gpu-yp-sas activated
                "prepare": [
                    {
                        "action": "prepare",
                        "name": "tts-ru-oksana-gpu-yp-sas"
                    }
                ],
                "activate": [
                    {
                        "action": "activate",
                        "name": "tts-ru-oksana-gpu-yp-sas"
                    }
                ],
            },

            # shitova prestable
            "tts-ru-gpu-prestable-yp-sas": {
                # prepare after tts-ru-oksana-gpu-yp-vla prepared
                # activate after tts-ru-oksana-gpu-yp-vla activated
                "prepare": [
                    {
                        "action": "prepare",
                        "name": "tts-ru-oksana-gpu-yp-vla"
                    }
                ],
                "activate": [
                    {
                        "action": "activate",
                        "name": "tts-ru-oksana-gpu-yp-vla"
                    }
                ]
            },

            # shitova
            "tts-ru-gpu-yp-sas": {
                # prepare after tts-ru-gpu-prestable-yp-sas prepared
                # activate after tts-ru-gpu-prestable-yp-sas activated
                "prepare": [
                    {
                        "action": "prepare",
                        "name": "tts-ru-gpu-prestable-yp-sas"
                    }
                ],
                "activate": [
                    {
                        "action": "activate",
                        "name": "tts-ru-gpu-prestable-yp-sas"
                    }
                ],
            },
            "tts-ru-gpu-yp-vla": {
                # prepare after tts-ru-gpu-yp-sas prepared
                # activate after tts-ru-gpu-yp-sas activated
                "prepare": [
                    {
                        "action": "prepare",
                        "name": "tts-ru-gpu-yp-sas"
                    }
                ],
                "activate": [
                    {
                        "action": "activate",
                        "name": "tts-ru-gpu-yp-sas"
                    }
                ],
            },
        }
    }
}
