# coding: U8
import sandbox.common.types.client as ctc
import sandbox.projects.common.constants as consts

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny

from sandbox.projects.voicetech.resource_types import VOICETECH_TTS_FASTDATA_SMOKE_TEST, VOICETECH_TTS_FASTDATA_SMOKE_TEST_CASES


class BuildTtsFastDataSmokeTest(CommonBuildTask, nanny.ReleaseToNannyTask):
    """
    Build TTS Fast Data Smoke Test
    """
    type = "BUILD_TTS_FAST_DATA_SMOKE_TEST"
    execution_space = 80000  # 80 Gb
    input_parameters = CommonBuildTask.input_parameters
    client_tags = ctc.Tag.Group.LINUX
    TARGET_RESOURCE_TYPES = (
        VOICETECH_TTS_FASTDATA_SMOKE_TEST,
        VOICETECH_TTS_FASTDATA_SMOKE_TEST_CASES,
    )

    def on_enqueue(self):
        if '/trunk/' in self.ctx[consts.ARCADIA_URL_KEY]:
            decreased_space = 50 * 1024
            if decreased_space < self.execution_space:
                self.execution_space = decreased_space  # Decrease trunk build execution space
        self.ctx['definition_flags'] = self.ctx.get('definition_flags', '')
        CommonBuildTask.on_enqueue(self)

    def do_execute(self):
        CommonBuildTask.do_execute(self)

    def on_release(self, additional_parameters):
        # FIXME(mvel) a bit of copypaste here
        if nanny.STARTREK_TICKET_IDS_KEY in additional_parameters:
            self.ctx[nanny.STARTREK_TICKET_IDS_KEY] = additional_parameters[nanny.STARTREK_TICKET_IDS_KEY]

        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)

__Task__ = BuildTtsFastDataSmokeTest
