from sandbox import sdk2
from sandbox.common.types import client as ctc
from sandbox.projects.common import binary_task


class UniLogViewerUploader(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(binary_task.LastBinaryReleaseParameters):
        _lbrp = binary_task.binary_release_parameters(stable=True)

        input_yt_cluster = sdk2.parameters.String('Input YT cluster', default='hahn')
        input_yt_token = sdk2.parameters.String('Input YT token', required=True)
        input_regexp = sdk2.parameters.String('Input regexp', default='//logs/qloud-runtime-log/stream/5min/.+')
        input_project = sdk2.parameters.String('Input project', default='voice-ext')
        input_environment = sdk2.parameters.String('Input environment', default='station-stable')
        tmp_path = sdk2.parameters.String('Tmp path', default='//home/voice/unilogviewer/tmp/')
        save_status = sdk2.parameters.Bool('Save status?')
        with save_status.value[True]:
            status_string_path = sdk2.parameters.String(
                'Status string path', default='//home/voice/unilogviewer/status')

        yt_storage = sdk2.parameters.Bool('Save to YT?', default=True)
        with yt_storage.value[True]:
            yt_cluster = sdk2.parameters.String('YT cluster', default='hahn')
            yt_token = sdk2.parameters.String('YT token', required=True)
            yt_table = sdk2.parameters.String('YT table', default='//home/yabs/stat/tmp/voice/unilog')

        ydb_storage = sdk2.parameters.Bool('Save to YDB?')
        with ydb_storage.value[True]:
            ydb_cluster = sdk2.parameters.String('YDB cluster', default='NONE')
            ydb_database = sdk2.parameters.String('YDB database', default='NONE')
            ydb_table = sdk2.parameters.String('YDB table', default='NONE')
            ydb_token = sdk2.parameters.String('YDB token name', required=True)

    class Requirements(sdk2.Requirements):

        class Caches(sdk2.Requirements.Caches):
            pass

        client_tags = ctc.Tag.LINUX_PRECISE
        cores = 1

    def on_execute(self):
        input_yt_cluster = self.Parameters.input_yt_cluster
        input_yt_token = sdk2.Vault.data(self.owner, self.Parameters.input_yt_token)
        input_regexp = self.Parameters.input_regexp
        input_project = self.Parameters.input_project
        input_environment = self.Parameters.input_environment
        tmp_path = self.Parameters.tmp_path
        status_string_path = self.Parameters.status_string_path if self.Parameters.save_status else ''

        yt_storage = {}
        if self.Parameters.yt_storage:
            yt_storage['proxy'] = self.Parameters.yt_cluster
            yt_storage['table'] = self.Parameters.yt_table
            yt_storage['token'] = sdk2.Vault.data(self.owner, self.Parameters.yt_token)

        ydb_storage = {}
        if self.Parameters.ydb_storage:
            ydb_storage['endpoint'] = self.Parameters.ydb_cluster
            ydb_storage['database'] = self.Parameters.ydb_database
            ydb_storage['table'] = self.Parameters.ydb_table
            ydb_storage['token'] = sdk2.Vault.data(self.owner, self.Parameters.ydb_token)

        from voicetech.infra.unilogviewer.uploader import upload
        upload(
            input_yt_cluster=input_yt_cluster,
            input_yt_token=input_yt_token,
            input_regexp=input_regexp,
            input_project=input_project,
            input_environment=input_environment,
            tmp_path=tmp_path,
            status_string_path=status_string_path,
            yt_storage=yt_storage,
            ydb_storage=ydb_storage,
        )
