# -*- coding: utf-8 -*-

import logging
import re

from sandbox import sdk2
from sandbox.projects.voicetech import resource_types
from sandbox.sandboxsdk.svn import Arcadia


class BuildMarkerTestsData(sdk2.Task):
    ''' create resource with data for alice marker_tests
        (export DATA_PATH folder from svn(arcadia))
    '''
    DATA_PATH = 'alice/acceptance/cli/marker_tests/data'

    class Parameters(sdk2.Task.Parameters):
        checkout_arcadia_from_url = sdk2.parameters.String(
            'Arcadia url',
            default='arcadia:/arc/trunk/arcadia',
            required=True,
        )

    def on_execute(self):
        # create result resource
        result_filename = 'marker_tests_data'
        result_resource = resource_types.ALICE_MARKER_TESTS_DATA(
            self,
            "Alice uniproxy marker_tests data for url={}".format(self.Parameters.checkout_arcadia_from_url),
            result_filename,
            ttl=40,
        )
        result_data = sdk2.ResourceData(result_resource)
        result_path = str(result_data.path)

        url = self._get_arcadia_url()
        logging.info("EXPORT '{}' TO '{}'".format(url, result_path))
        Arcadia.export(url, result_path)

    def _get_arcadia_url(self):
        url_arcadia = self.Parameters.checkout_arcadia_from_url
        url_parsed = Arcadia.parse_url(url_arcadia)
        path_new = re.sub(r'/arcadia.*', '/arcadia/' + self.DATA_PATH, url_parsed.path, count=1)
        return Arcadia.replace(url_arcadia, path=path_new)
