import sandbox.common.types.client as ctc
import sandbox.projects.common.constants as consts
import sandbox.projects.release_machine.mixins.build as rm_build_mixin

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.voicetech.resource_types import ALICE_MARKER_TESTS_EXE


class BuildMarkerTestsExe(rm_build_mixin.ComponentReleaseTemplate, CommonBuildTask):
    """ Build alice marker_tests executable
    """

    type = 'BUILD_MARKER_TESTS_EXE'
    execution_space = 10000  # 80 Gb
    input_parameters = CommonBuildTask.input_parameters
    client_tags = ctc.Tag.Group.LINUX
    TARGET_RESOURCE_TYPES = (
        ALICE_MARKER_TESTS_EXE,
    )

    def on_enqueue(self):
        if '/trunk/' in self.ctx[consts.ARCADIA_URL_KEY]:
            decreased_space = 50 * 1024
            if decreased_space < self.execution_space:
                self.execution_space = decreased_space  # Decrease trunk build execution space
        CommonBuildTask.on_enqueue(self)


__Task__ = BuildMarkerTestsExe
