# -*- coding: utf-8 -*-

import os

from sandbox.projects.common.nanny import nanny
from sandbox.projects.sandbox import remote_copy_resource


class UploadVoicetechResource(remote_copy_resource.RemoteCopyResource, nanny.ReleaseToNannyTask):

    cores = 1
    type = 'UPLOAD_VOICETECH_RESOURCE'

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)

    def get_targets(self):
        return [self.ctx['resource_type'].arcadia_build_path]

    def get_resources(self):
        return {
            self.ctx['resource_type'].name: {
                'description': self.ctx['resource_type'].name,
                'resource_type': self.ctx['resource_type'],
                'resource_path': os.path.basename(self.ctx['resource_type'].arcadia_build_path),
            }
        }


__Task__ = UploadVoicetechResource
