METAINFO_PRESET = {
    "avg_task_clock": {
        "best_value": "Min",
    },
    "avg_cpu_utilized": {
        "best_value": "Min",
    },
    "*task_clock": {
        "best_value": "Min",
    },
    "*cpu_utilized": {
        "best_value": "Min",
    }
}


def send_to_pulsar(preset, vqe_name, dataset_name, n_runs, flags, metrics, user_tags=None):
    # We cannot import pulsar on global level
    from pulsar import (
        PulsarClient,
        DatasetInfo,
        ModelInfo,
        InstanceInfo,
    )
    user_tags = user_tags or []
    options = {
        "vqe_custom_flags": flags,
    }
    model = ModelInfo(
        name=vqe_name + "_" + preset,
        operation_options=options,
    )
    dataset = DatasetInfo(
        name=dataset_name,
        info={"n_runs": n_runs},
    )
    metrics["_metainfo"] = METAINFO_PRESET

    instance = InstanceInfo(
        model=model,
        dataset=dataset,
        result=metrics,
        tags=["vqe-perf"] + user_tags,
        name=("vqe_perf_" + vqe_name + "_preset_" + preset + "_on_" + dataset_name).replace(" ", "_"),
        description="vqe performance test, VQE-250",
    )

    client = PulsarClient()
    client.add(instance)
