# coding: utf-8

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny

import sandbox.projects.wabba.resource_types as resource_types

RESOURCES = {
    'wbjk_server': resource_types.WabbaSrvBinary,
    'wqd': resource_types.WqdBinary,
    'configurator': resource_types.WabbaConfigurator
}


class BuildWabbaServ(nanny.ReleaseToNannyTask, YaMakeTask):
    """
    Build wabbaserv.
    """
    type = 'BUILD_WABBASRV'
    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter,
        build_params.UseArcadiaApiFuse,
        build_params.AllowArcadiaApiFallback,
        build_params.ClearBuild,
        nanny.StartrekTicketIdsParameter
    ]

    def get_resources(self):
        return {
            k: {'description': 'wbjk {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems()
        }

    def get_targets(self):
        return [
            'search/mon/wabbajack/bin/wbjk_server',
            'search/mon/wabbajack/bin/wqd',
            'search/mon/wabbajack/bin/configurator'
        ]

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)} for k, rtype in RESOURCES.iteritems()]
