# coding: utf-8

from sandbox import sdk2
from sandbox.projects.resource_types import YA_PACKAGE as _YA_PACKAGE

from sandbox.projects.resource_types.releasers import marty


class WabbaResource(sdk2.Resource):
    """
    wbjk res
    """
    releasable = True
    any_arch = False
    releasers = marty
    auto_backup = True


class WabbaSrvBinary(WabbaResource):
    """
    wbjk_srv binary
    """
    arcadia_build_path = 'search/mon/wabbajack/bin/wbjk_server'


class WqdBinary(WabbaResource):
    """
    wqd binary
    """
    arcadia_build_path = 'search/mon/wabbajack/bin/wqd'


class WabbaConfigurator(WabbaResource):
    """
    wabbajack configurator
    """
    arcadia_build_path = 'search/mon/wabbajack/bin/configurator'


class WabbaIconostasisScreenshoter(WabbaResource):
    """
    icscr binary
    """
    arcadia_build_path = 'search/mon/wabbajack/bin/icscr'


class WabbaStates(_YA_PACKAGE):
    """
    wabbajack states tarball
    """
    releasers = marty


class WabbaScripts(_YA_PACKAGE):
    """
    wabbajack scripts tarball
    """
    releasers = marty


class WabbaConfigs(_YA_PACKAGE):
    """
    wabbajack conf tarball
    """
    releasers = marty
