# coding: utf-8

import os

import sandbox.common.types.client as ctc
from sandbox.projects.walle import resource_types
from sandbox.projects.common.juggler import base


class BuildWalleScripts(base.BaseBuildJugglerTask):
    """
    Build virtualenv with walle.scripts.
    """

    type = 'BUILD_WALLE_SCRIPTS'
    VAULT_OWNER = 'WALLE'
    SSH_KEY_VAULT_NAME = 'ssh-key'

    execution_space = 500
    client_tags = ctc.Tag.LINUX_PRECISE

    GIT_URL_TEMPLATE = "ssh://git@bb.yandex-team.ru/nanny/{name}.git"
    REPO_NAME = "wall-e.scripts"
    TGZ_PATH = "wall-e.scripts.tar.gz"

    def on_execute(self):
        commit = self._checkout(submodules=False)
        version = self._build_venv(
            os.path.join(self._checkout_path, "requirements.txt"),
            self.TGZ_PATH)
        self._make_resource(
            path=self.TGZ_PATH,
            version=version,
            resource_type=resource_types.WALLE_SCRIPTS,
            description='{0} tarball, tag {1}, commit {2}'.format(self.REPO_NAME, self.ctx['tag'], commit))


__Task__ = BuildWalleScripts
