import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp, ProcessLog
from sandbox.common.types.resource import State
from sandbox.common.errors import TaskFailure
from sandbox.projects.common.juggler import jclient


class FindWalleMaintenance(sdk2.Task):
    """Find which hosts stucked in maintenance."""

    releasers = ['dldmitry']

    def on_execute(self):
        archive_resource = sdk2.Resource['WALLE_FIND_MAINTENANCE'].find(
            attrs=dict(resource_name="walle-maintenance-finder"),
            state=State.READY
        ).order(-sdk2.Resource.id).first()
        if archive_resource is None:
            raise TaskFailure("Archive not found!")
        archive_path = str(sdk2.ResourceData(archive_resource).path)

        walle_token = sdk2.Vault.data('WALLE', 'walle-token')
        startrek_token = sdk2.Vault.data('WALLE', 'walle-st-token')
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger()) as pl:
            sp.check_call(['tar', 'xf', archive_path], stdout=pl.stdout, stderr=sp.STDOUT)
            raw_response = sp.check_output([
                './find',
                '--no-dry-run',
                '--walle-token', walle_token,
                '--startrek-token', startrek_token,
                'maintenance'
            ], timeout=900, stderr=pl.stderr)
            logging.debug("Sync output: %r", raw_response)

        jclient.send_events_to_juggler('find-walle-maintenance', 'scheduler', 'OK', 'passed')
