# coding: utf-8
# Helper tool, copied from releaselib
import os
import shutil
import tempfile

from sandbox.sandboxsdk.process import run_process

_PYPIRC_TEMPLATE = '''
[distutils]
index-servers =
    yandex
[yandex]
repository: {repository}
username: {username}
password: {password}
'''


def _create_pypirc(path, username, password, repository):
    pypirc_path = os.path.join(path, '.pypirc')
    with open(pypirc_path, 'w') as pypirc:
        pypirc_content = _PYPIRC_TEMPLATE.format(username=username, password=password, repository=repository)
        pypirc.write(pypirc_content)


def upload_to_pypi(dist_path, username, password, repository='http://pypi.yandex-team.ru/simple'):
    """Upload `dist_path` into PyPI-repo `repository`, using provided login and password."""

    temp_dir = tempfile.mkdtemp()
    try:
        _create_pypirc(temp_dir, username, password, repository)

        twine_env = os.environ.copy()
        twine_env['HOME'] = temp_dir

        run_process(
            ['twine', 'upload', '-r', 'yandex', dist_path],
            environment=twine_env, log_prefix="twine",
            wait=True, check=True,
        )
    finally:
        shutil.rmtree(temp_dir)
