# coding: utf-8
from __future__ import absolute_import

from sandbox import sdk2
from sandbox.common.types import resource as ctr
# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class WALLE_STATS(AbstractResource):
    """
        Wall-E statistics
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    ttl = 365


class WALLED_ARCADIA(sdk2.Resource):
    """
        Wall-E server tar with main binary and configs
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    ttl = 14
    releasers = ['WALLE', 'nanny-robot']

class WALLED_GO(sdk2.Resource):
    """
        Wall-E server tar with one of main binaries (go) and configs
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    ttl = 14
    releasers = ['WALLE', 'nanny-robot']

class WALLED_GO_UNI(sdk2.Resource):
    """
        Wall-E Go server (new)
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['WALLE']

class WALLE_BACKUP_RESTORE_SCRIPTS(AbstractResource):
    """
        Wall-E backup-restore scripts
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['WALLE', 'nanny-robot']


class WALLE_SCRIPTS(AbstractResource):
    """
        Scripts for Wall-E
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['WALLE', 'nanny-robot']


class WALLE_UI(AbstractResource):
    """
        Wall-E UI
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['WALLE', 'INFRACLOUDUI', 'nanny-robot']


class WALLE_SAVE_PROJECTS(AbstractResource):
    """
        Wall-E save projects binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['WALLE']


class WALLE_FIND_MAINTENANCE(AbstractResource):
    """
        Wall-E find maintenance binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['WALLE']


class WALLE_DB_MONITOR(AbstractResource):
    """
        Database monitoring demon
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['WALLE']
