# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
import sandbox.common.errors

from .. import hermione_common_task


class WeatherFrontendHermioneGeneric(
    hermione_common_task.TelegramNotifyTaskMixin,
    hermione_common_task.Task
):

    class Parameters(
        hermione_common_task.TelegramNotifyParameters,
        hermione_common_task.Parameters
    ):
        pass

    def on_execute(self):
        super(WeatherFrontendHermioneGeneric, self).on_execute()
        logging.getLogger().setLevel(logging.INFO)

        with self.memoize_stage.install:
            with sdk2.helpers.ProgressMeter('Checkout and install npm packages'):
                self.exec_multiple_commands(self.Parameters.install_commands.split('\n'), 'install')

        with sdk2.helpers.ProgressMeter('Running tests'):
            self.run_tests()

        chat_id = self.Parameters.telegram_chat_id
        if chat_id:
            if not self.telegram_notify_should_skip():
                self.telegram_notify_chat(chat_id)

        if not self.Context.tests_status_success:
            raise sandbox.common.errors.TaskFailure('Tests failed')
