#  -*- coding: utf-8 -*-
# import io
# import json
# import logging
# import math
# from collections import defaultdict

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.weather.StatfaceReports.pogoda_analytics.du_recent import calc_report
from sandbox.sdk2 import yav
import datetime as dt


class MakeWeatherStatfaceReport(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = (
            PipEnvironment('yandex-yt'),
            PipEnvironment(
                'python-statface-client',
                version='0.154.0',
                custom_parameters=['requests==2.18.4'],
                use_wheel=False
            ),
        )

    class Parameters(sdk2.Task.Parameters):

        end_date = sdk2.parameters.String(
            'End date',
            description='Calc dashboard till this date. Left empty for today',
            required=False,
        )

        count_last = sdk2.parameters.Integer(
            'Count last',
            description='Number of days to calc',
            required=True,
            default=1
        )

        publish_to_statface_production = sdk2.parameters.Bool(
            'Publish to statface production',
            description='Publish to statface production if True, publish to beta if False',
            required=True,
            default=True
        )

    def on_execute(self):
        secret = yav.Secret('sec-01eq859mmbes005ber9mxa9t54')
        clickhouse_password_secret = yav.Secret('sec-01eps2rxaq90r8sf44dq8r6b6t')

        user = 'robot-weatherman'
        password = clickhouse_password_secret.data()['password']

        stat_token = secret.data()['statface_token']
        yql_token = secret.data()['yt_token']
        yt_token = secret.data()['yt_token']

        # user = 'robot-hieronymus'
        # password = uniquely_named_secret = sdk2.Vault.data('ch_password')

        # stat_token = sdk2.Vault.data('statface_token')
        # yt_token = sdk2.Vault.data('yt_token')
        # yql_token = sdk2.Vault.data('yt_token')

        end_date = dt.datetime.strptime(
            self.Parameters.end_date, '%Y-%m-%d'
        ) if len(self.Parameters.end_date) > 0 else None

        count_last = self.Parameters.count_last
        publish_to_statface_prod = self.Parameters.publish_to_statface_production

        calc_report(user, password, stat_token, yql_token, yt_token, end_date, count_last, publish_to_statface_prod)
