# -*- coding: utf-8 -*-

from sandbox.common import rest
from sandbox.projects.porto import BuildPortoLayer
from sandbox import sdk2
from sandbox.sandboxsdk.parameters import SandboxBoolParameter

class StartStatic(SandboxBoolParameter):
    name = 'rebuild_static'
    description = 'Rebuild L7 static'
    default_value = False
    required = True

class WeatherBuildPortoLayer(BuildPortoLayer.BuildPortoLayer):
    """A wrapper around BUILD_PORTO_LAYER """

    type = "WEATHER_BUILD_PORTO_LAYER"

    input_parameters = BuildPortoLayer.BuildPortoLayer.input_parameters + [StartStatic]

    def on_execute(self):
        # нужно научиться прокидывать self.Parameters
        # падает с ошибкой AttributeError: WeatherBuildPortoLayer instance has no attribute 'Parameters'
        # os.environ["rebuild_static"] = 1 if self.Parameters.rebuild_static else 0
        BuildPortoLayer.BuildPortoLayer.on_execute(self)
        self.descr = rest.Client().task[self.id].read()["description"]
