import logging

from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox import sdk2, common

YT_SECRET_OWNER = 'WEATHER-ADMIN'
YT_SECRET_NAME = 'yt_yql_token'
YT_METEO_UZ_RAW = '//home/meteo/aurora/meteo_uz_forecasts'
YT_METEO_UZ = '//home/meteo/aurora/meteo_uz_forecasts_merged'
METEO_UZ_SCHEMA = [
    {'name': 'gentime', 'type': 'int64'},
    {'name': 'date', 'type': 'string'},
    {'name': 'part', 'type': 'string'},
    {'name': 'location_id', 'type': 'int64'},
    {'name': 'latitude', 'type': 'double'},
    {'name': 'longitude', 'type': 'double'},
    {'name': 'min_temperature', 'type': 'int64'},
    {'name': 'max_temperature', 'type': 'int64'},
    {'name': 'min_wind_speed', 'type': 'int64'},
    {'name': 'max_wind_speed', 'type': 'int64'},
    {'name': 'min_wind_gust', 'type': 'int64'},
    {'name': 'max_wind_gust', 'type': 'int64'},
    {'name': 'wind_direction', 'type': 'string'},
    {'name': 'condition', 'type': 'string'},
    {'name': 'icon', 'type': 'string'},
]


class WeatherMergeMeteoUz(sdk2.Task):
    """Merge Aurora parsed Meteo.uz forecasts"""
    class Requirements(sdk2.Task.Requirements):
        environments = (PipEnvironment('yandex-yt', use_wheel=True),)

    class Parameters(sdk2.Task.Parameters):
        """Define task parameters"""
        kill_timeout = 1800
        max_restarts = 3

    def on_execute(self):
        from yt.wrapper import YtClient
        yt_client = YtClient(proxy='arnold', token=sdk2.Vault.data(YT_SECRET_OWNER, YT_SECRET_NAME))

        with yt_client.Transaction():
            raw_tables = yt_client.list(YT_METEO_UZ_RAW, absolute=True)
            if not raw_tables:
                raise common.errors.TaskError('No source raw tables')

            if not yt_client.exists(YT_METEO_UZ):
                logging.info('%s is absent. Creating...', YT_METEO_UZ)
                yt_client.create('table', YT_METEO_UZ, attributes={'schema': METEO_UZ_SCHEMA})

            logging.info('Start merging %s with %s', YT_METEO_UZ, raw_tables)
            yt_client.run_sort([YT_METEO_UZ] + raw_tables, YT_METEO_UZ, sort_by='gentime')
            logging.info('Merging is finished')
            for table in raw_tables:
                logging.info('Remove %s', table)
                yt_client.remove(table)
