# -*- coding: utf-8 -*-
import os

from sandbox.projects.weather import WEATHER_PG_DUMP
from sandbox.projects.sandbox import LXC_CONTAINER
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp


class WeatherPgDumpTable(sdk2.Task):
    """
    Таск для дампа таблицы из PG погоды
    """

    class Parameters(sdk2.Task.Parameters):
        max_restarts = 1
        kill_timeout = 1 * 3600

        hosts = sdk2.parameters.String(
            'List of PostgreSQL hosts',
            default='man-ltoekmztm43eaok9.db.yandex.net,sas-uakkbrj86z0y6ra1.db.yandex.net,vla-uawpuw4d75ei7kcr.db.yandex.net',
            required=True,
        )
        port = sdk2.parameters.Integer('Database port', default=6432, required=True)
        user = sdk2.parameters.String('Database username', default='weather', required=True)
        database = sdk2.parameters.String('Database name to dump', default='weather_prod', required=True)
        tablename = sdk2.parameters.String('Table name to dump', default='s3_files', required=True)
        vault_key = sdk2.parameters.String(
            'Vault key with password from DB', default='WEATHER_PROD_PG_PASSWORD', required=True
        )
        _container = sdk2.parameters.Container(
            'Environment container resource', default_value=1463229735, resource_type=LXC_CONTAINER, required=True
        )

    def on_execute(self):
        connection_string = 'host=%s port=%s dbname=%s user=%s sslmode=require target_session_attrs=any' % (
            self.Parameters.hosts,
            self.Parameters.port,
            self.Parameters.database,
            self.Parameters.user,
        )
        filename = "dump.sql"
        if os.path.exists(filename):
            os.remove(filename)
        cmd = [
            'pg_dump',
            connection_string,
            '-a',
            '-t',
            self.Parameters.tablename,
            '-f',
            filename,
        ]
        env = {
            'PGPASSWORD': sdk2.Vault.data(self.owner, self.Parameters.vault_key),
        }
        with sdk2.helpers.ProcessLog(self, logger="pg_dump") as pl:
            sp.check_call(cmd, stderr=pl.stderr, stdout=pl.stdout, env=env)
            WEATHER_PG_DUMP(self, "Weather PostgreSQL table dump", filename)
