# -*- coding: utf-8 -*-

import sandbox.projects.common.nanny.nanny as nanny
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.common.build.YaMake2 import YaMake2
import sandbox.projects.common.build.parameters as build_parameters
import sandbox.projects.common.constants as consts


class WeatherYaMake(nanny.ReleaseToNannyTask2, YaMake2):
    '''A wrapper around YaMake2'''

    name = 'WEATHER_YA_MAKE'

    class Parameters(YaMake2.Parameters):
        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        use_arc_instead_of_aapi = build_parameters.UseArcInsteadOfArcadiaApi(default_value=False)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)
        build_system = build_parameters.BuildSystem(default_value=consts.SEMI_DISTBUILD_BUILD_SYSTEM)


class WeatherYaMakeDeploy(release_integration.ReleaseToYaDeployTask2, YaMake2):
    '''A wrapper around YaMake2 with deploy integration'''

    name = 'WEATHER_YA_MAKE_DEPLOY'

    class Parameters(YaMake2.Parameters):
        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        use_arc_instead_of_aapi = build_parameters.UseArcInsteadOfArcadiaApi(default_value=False)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)
        build_system = build_parameters.BuildSystem(default_value=consts.SEMI_DISTBUILD_BUILD_SYSTEM)

    YP_TOKEN_YAV_SECRET_ID = 'sec-01eaz5ep4d83m705a0q7j5txsn'
