# -*- coding: utf-8 -*-

from sandbox import sdk2


class WEATHER_MTN_BALANCER_PUSHCLIENT_INSTANCECTL_CONF(sdk2.Resource):
    """
    instancectl.conf for weather balancer with push-client to logstores,
    logrotate and yasm subagent
    """

    releasable = True
    auto_backup = True


class WEATHER_MTN_BALANCER_YT_PUSHCLIENT_INSTANCECTL_CONF(sdk2.Resource):
    """
    instancectl.conf for weather balancer with push-client to yt and logstores,
    logrotate and yasm subagent
    """

    releasable = True
    auto_backup = True


class WEATHER_API_MTN_BALANCER_PUSHCLIENT_INSTANCECTL_CONF(sdk2.Resource):
    """
    instancectl.conf for weather API balancer with push-client to logstores,
    logrotate and yasm subagent
    """

    releasable = True
    auto_backup = True


class WEATHER_BASE_API_BINARY(sdk2.Resource):
    """Weather basic api executable"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_INFORMER_BINARY(sdk2.Resource):
    """Weather apphost informer binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_TAXIFACT_BINARY(sdk2.Resource):
    """Weather apphost taxifact binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_THUNDER_BINARY(sdk2.Resource):
    """Weather apphost thunder binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_TOPOGRAPHY_BINARY(sdk2.Resource):
    """Weather apphost topography binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_THUNDER_API_BINARY(sdk2.Resource):
    """Weather thunder api executable"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_THUNDER_PROXY_BINARY(sdk2.Resource):
    """Weather thunder proxy executable"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_BINARY(sdk2.Resource):
    """Weather workers queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_ADMIN_BINARY(sdk2.Resource):
    """Weather admin binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_EXPORTS_BINARY(sdk2.Resource):
    """Weather workers exports queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_CRAWLERS_BINARY(sdk2.Resource):
    """Weather workers crawlers queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_COMMON_BINARY(sdk2.Resource):
    """Weather workers common queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class PORTO_LAYER_WEATHERAPI(sdk2.Resource):
    """Resource with weather api image for porto"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["khomikki", "cmind", "WEATHER"]


class PORTO_LAYER_WEATHERFRONTEND_BASE(sdk2.Resource):
    """Resource with weather frontend image for porto"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["oggo", "vaseker", "WEATHER", "WEATHER_FRONTEND"]


class PORTO_LAYER_WEATHERFRONTEND(sdk2.Resource):
    """Resource with weather frontend image for porto"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["oggo", "vaseker", "WEATHER", "WEATHER_FRONTEND"]


class PORTO_LAYER_WEATHERWORKER8(sdk2.Resource):
    """Resource with weather 8 CPU worker image for porto"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ['WEATHER']


class PORTO_LAYER_WEATHERWORKER(sdk2.Resource):
    """Resource with weather worker image for porto"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ['WEATHER']


class PORTO_LAYER_WEATHERWORKER_2(sdk2.Resource):
    """Resource with weather worker image for porto (layer 2)"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ['WEATHER']


class PORTO_LAYER_WEATHERWORKER_3(sdk2.Resource):
    """Resource with weather worker image for porto (layer 3)"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ['WEATHER']


class QEMU_IMAGE_WEATHERDEVWORKER(sdk2.Resource):
    """Resource with weather dev worker image for qemu-kvm"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ['WEATHER']


class WEATHER_NOWCASTBOT_BINARY(sdk2.Resource):
    """Weather telegram nowcast bot binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_IMPORTS_BINARY(sdk2.Resource):
    """Weather workers imports queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_MAPS_BINARY(sdk2.Resource):
    """Weather workers maps queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_WARNINGS_BINARY(sdk2.Resource):
    """Weather workers warnings queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_WARNINGS_CPP_BINARY(sdk2.Resource):
    """Weather cpp workers warnings queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_GRIB_SET(sdk2.Resource):
    """Sets key/value pairs in the input GRIB file and writes each message to the output_grib_file"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_GRIB_COPY(sdk2.Resource):
    """Copies the content of GRIB files printing values of some keys"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_NOWCASTING_BINARY(sdk2.Resource):
    """Weather workers nowcasting queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_APPLY_BINARY(sdk2.Resource):
    """Weather workers apply queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_SCHEDULER_BINARY(sdk2.Resource):
    """Weather scheduler binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_ADMIN_MONITORINGS_BINARY(sdk2.Resource):
    """Weather admin monitorings binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_HTTP_MONITORINGS_BINARY(sdk2.Resource):
    """Weather http server monitorings binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_YASM_WORKERSTATS_BINARY(sdk2.Resource):
    """Weather yasm stats binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_FC_PACKER_BINARY(sdk2.Resource):
    """Weather ForecastContainer Packer binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_WRFOUT_BINARY(sdk2.Resource):
    """Weather WRFOUT binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_WRF_BINARY(sdk2.Resource):
    """Weather workers wrf queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_NOWCASTING_BINARY(sdk2.Resource):
    """Weather nowcasting binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_NOWCASTING_GPU_BINARY(sdk2.Resource):
    """Weather nowcasting GPU binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_SUPERFACT_FRAME_BINARY(sdk2.Resource):
    """Weather superfact frame binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_SUPERFACT_MOVER_BINARY(sdk2.Resource):
    """Weather superfact mover binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_EXPORT_FC_BINARY(sdk2.Resource):
    """Weather export_fc binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_TILESERVER_BINARY(sdk2.Resource):
    """Weather tile-server binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_FRONTEND_PUMPKIN_BINARY(sdk2.Resource):
    """Weather frontend pumpkin binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_EXPORTS_CPP_BINARY(sdk2.Resource):
    """Weather cpp exports binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_CRAWLERS_CPP_BINARY(sdk2.Resource):
    """Weather cpp crawlers binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_REMOTE_LOGGER_BINARY(sdk2.Resource):
    """Weather remote_log handler binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_ALERT_REQUEST_BINARY(sdk2.Resource):
    """Weather apphost alert_request binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_AUTH_REQUEST_BINARY(sdk2.Resource):
    """Weather apphost auth_request binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_ALLERGENS_PERIODS_BINARY(sdk2.Resource):
    """Weather apphost allergens_periods binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_ALLERGENS_STATS_BINARY(sdk2.Resource):
    """Weather apphost allergens_stats binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_CLIMATE_BINARY(sdk2.Resource):
    """Weather apphost climate binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_EXP_FLAGS_BINARY(sdk2.Resource):
    """Weather apphost exp_flags binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_FACT_BINARY(sdk2.Resource):
    """Weather apphost fact binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_RESORTS_BINARY(sdk2.Resource):
    """Weather apphost resorts binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_GEO_LOCATION_BINARY(sdk2.Resource):
    """Weather apphost geo_location binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_GEOAPICPP_BINARY(sdk2.Resource):
    """Weather apphost geoapi_cpp binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_MAGNETIC_FIELD_BINARY(sdk2.Resource):
    """Weather apphost magnetic_field binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_ACC_PREC_FIELD_BINARY(sdk2.Resource):
    """Weather apphost accumulated precipitations binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_METEUM_BINARY(sdk2.Resource):
    """Weather apphost meteum binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_NOWCAST_BINARY(sdk2.Resource):
    """Weather apphost nowcast binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_NOWCAST_REPORTS_BINARY(sdk2.Resource):
    """Weather apphost nowcast_reports binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_STORE_NOWCAST_REPORT_BINARY(sdk2.Resource):
    """Weather apphost store_nowcast_report binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_STORE_USER_REPORT_BINARY(sdk2.Resource):
    """Weather apphost store_user_report binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_FORECAST_HISTORY_BINARY(sdk2.Resource):
    """Weather apphost forecast_history binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_FORECAST_POSTPROC_BINARY(sdk2.Resource):
    """Weather apphost forecast_postproc binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_V3_NOWCAST_ALERT_RESPONSE_BINARY(sdk2.Resource):
    """Weather apphost v3_nowcast_alert_response binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_WIZARD_BINARY(sdk2.Resource):
    """Weather apphost wizard binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_API_BINARY(sdk2.Resource):
    """Weather apphost api adapter binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_HOLIDAYS_BINARY(sdk2.Resource):
    """Weather apphost holidays binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_NOWCAST_TRANSPARENT_TILE_BINARY(sdk2.Resource):
    """Weather apphost nowcast transparent tile binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_TRANSLATIONS_BINARY(sdk2.Resource):
    """Weather apphost translations binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_USER_INFO_BINARY(sdk2.Resource):
    """Weather apphost user_info binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_LORIS_GEOIDS(sdk2.Resource):
    """Weather loris geoid list"""

    releasable = True
    auto_backup = True
    ttl = 'inf'


class WEATHER_SPECIAL_LOCATIONS(sdk2.Resource):
    """Weather special locations list"""

    releasable = True
    auto_backup = True
    ttl = 'inf'


class WEATHER_TRANSLATIONS(sdk2.Resource):
    """Base class for all Weather translations from Tanker"""

    releasable = True
    auto_backup = True

    tanker_base_url = 'https://tanker-api.yandex-team.ru'
    tanker_project = 'pogoda'
    tanker_branch = 'master'
    tanker_format = 'json'
    tanker_keysets = []
    tanker_params = ['all-forms=1', 'safe=1']


class WEATHER_API_TRANSLATIONS(WEATHER_TRANSLATIONS):
    """Weather V3 API translations"""

    # https://github.yandex-team.ru/weather/api/blob/master/server/api-v2/lib/translations.js#L3
    tanker_keysets = [
        'weather-conditions-v3',
        'weather-moon',
        'pollution-affect',
        'pollution-level',
        'pollution-substance',
        'weather-wind',
        'weather-uv-index',
    ]


class WEATHER_V3_NOWCAST_ALERT_RESPONSE_TRANSLATIONS(WEATHER_TRANSLATIONS):
    """Weather apphost v3_nowcast_alert_response translations"""

    tanker_keysets = [
        'v3-alerts-rules',
        'v3-short-alerts-rules',
        'v3-alerts-prec-type',
        'v3-alerts-prec-strength',
        'v3-alerts-ts',
    ]


class WEATHER_WIZARD_TRANSLATIONS(WEATHER_TRANSLATIONS):
    """Weather apphost wizard translations"""

    tanker_keysets = ['weather-conditions-v3', 'wizard']


class WEATHER_WARNINGS_TRANSLATIONS(WEATHER_TRANSLATIONS):
    """Weather apphost wizard translations"""

    tanker_keysets = [
        'warnings',
        'warnings-short',
        'warnings-viber',
        'warnings-alice',
        'warnings-push-messages',
        'warnings-status',
        'warnings-without-horizon',
    ]


class WEATHER_VIBER_CHATBOT_TRANSLATIONS(WEATHER_TRANSLATIONS):
    """Weather viber chatbot translations"""

    tanker_keysets = ['viber-chatbot']


class WEATHER_SKI_RESORTS_PUSH_TRANSLATIONS(WEATHER_TRANSLATIONS):
    """Weather ski resort push translations"""

    tanker_keysets = ['ski-resort-push']


class WEATHER_PUSH_TITLES_TRANSLATIONS(WEATHER_TRANSLATIONS):
    """Weather push titles translations"""

    tanker_keysets = ['push-titles']


class WEATHER_CLIMATE_ZONE_TRANSLATIONS(WEATHER_TRANSLATIONS):
    """Weather climate zone translations"""

    tanker_keysets = ['climate-zone']


class WEATHER_APPHOST_LORIS_BINARY(sdk2.Resource):
    """Weather loris binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_API_AUTHZ(sdk2.Resource):
    """Weather authz tarball"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = False


class WEATHER_APPHOST_WARNINGS_BINARY(sdk2.Resource):
    """Weather apphost warnings binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_LOAD_AMMO(sdk2.Resource):
    """Weather load ammo file"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = False


class WEATHER_APPHOST_WARNINGS_MCHS_BINARY(sdk2.Resource):
    """Weather apphost warnings_mchs binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_PAST_PREC_BINARY(sdk2.Resource):
    """Weather apphost nearest_prec binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_RASTER_MAPS_BINARY(sdk2.Resource):
    """Weather apphost raster_maps binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_APPHOST_TIDE_BINARY(sdk2.Resource):
    """Weather apphost tide binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_PG_DUMP(sdk2.Resource):
    """Weather pg_dump file"""

    releasable = False
    auto_backup = False
    ttl = 14
    executable = False


class WEATHER_TAXIFACT_BINARY(sdk2.Resource):
    """Weather taxifact binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_NOWCAST_COMPARISON_WORKER(sdk2.Resource):
    """Weather nowcast comparison worker binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_EXTERNAL_BINARY(sdk2.Resource):
    """Weather workers imports queue binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_DEVELOPER_CABINET_MANAGE_BINARY(sdk2.Resource):
    """Weather developer cabinet django manage.py binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_DEVELOPER_CABINET_WSGI_BINARY(sdk2.Resource):
    """Weather developer cabinet wsgi binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_AMATEUR_STATIONS_BINARY(sdk2.Resource):
    """Weather amateur stations binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_TOLOKA_API_BINARY(sdk2.Resource):
    """Weather toloka api binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_TOLOKA_WORKER_BINARY(sdk2.Resource):
    """Weather toloka worker binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_QUEUE_APPLY_CPP_BINARY(sdk2.Resource):
    """Weather cpp apply binary"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
    executable = True


class WEATHER_NEXTJS_BUNDLE(sdk2.Resource):
    """Weather frontend Next.js bundle"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["oggo", "vaseker", "WEATHER", "WEATHER_FRONTEND"]


class WEATHER_NEXTJS_STATIC(sdk2.Resource):
    """Weather frontend Next.js static folder"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["oggo", "vaseker", "WEATHER", "WEATHER_FRONTEND"]


class WEATHER_NEXTJS_PORTO_LAYER(sdk2.Resource):
    """Weather frontend Next.js base porto layer"""

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["oggo", "vaseker", "WEATHER", "WEATHER_FRONTEND"]


class WEATHER_METEOALARM_GEOCODING(sdk2.Resource):
    """Weather geocoding json from meteoalarm"""

    releasable = True
    auto_backup = True
    ttl = 'inf'
