# -*- coding: utf-8 -*-
# import json
# import sys
import unittest

import evlogstat


class TestEvlogstatBlender(unittest.TestCase):
    result1 = dict((
        ('AllfactorsTime.Min', 0),
        ('CPUUsage.Min', 758031),
        ('CollectionsSerpData-Merge.Min', 6),
        ('Dumper-Fetch.Min', 17),
        ('Dumper-Merge.Min', 20),
        ('ExtraMergeCycles.Min', 5),
        ('FetchTime.Min', 0),
        ('ImgFreshFilter-Merge.Min', 4),
        ('ImgGroupingMerge-Merge.Min', 1046),
        ('ImgSerpData-Merge.Min', 24073),
        ('L4FormulaUpper-Fetch.Min', 2),
        ('Merge.Min', 868),
        ('MetaSearchTime.Min', 785522),
        ('OtherTime.Min', 154),
        ('PrepareClients.Min', 132907),
        ('RearrangeAfterBlend-rtmr-Overhead.Min', 4),
        ('RearrangeAfterBlend-rtmr.Min', 4),
        ('RearrangeAfterBlenderFactors-iq-Overhead.Min', 3),
        ('RearrangeAfterBlenderFactors-iq.Min', 3),
        ('RearrangeAfterFetch-dgq-Overhead.Min', 596),
        ('RearrangeAfterFetch-dgq.Min', 600),
        ('RearrangeAfterFetch-ii-Overhead.Min', 7882),
        ('RearrangeAfterFetch-ii.Min', 7887),
        ('RearrangeAfterFetch-iq-Overhead.Min', 501),
        ('RearrangeAfterFetch-iq.Min', 504),
        ('RearrangeAfterFetch-iwiz-Overhead.Min', 718),
        ('RearrangeAfterFetch-iwiz.Min', 721),
        ('RearrangeAfterFetch-rtmr-Overhead.Min', 1284),
        ('RearrangeAfterFetch-rtmr.Min', 1288),
        ('RearrangeAfterIntentWeights-rtmr-Overhead.Min', 4),
        ('RearrangeAfterIntentWeights-rtmr.Min', 4),
        ('RearrangeAfterMerge-dgq-Overhead.Min', 3259),
        ('RearrangeAfterMerge-dgq.Min', 3263),
        ('RearrangeAfterMerge-ii-Overhead.Min', 3400),
        ('RearrangeAfterMerge-ii.Min', 4453),
        ('RearrangeAfterMerge-iq-Overhead.Min', 2239),
        ('RearrangeAfterMerge-iq.Min', 2242),
        ('RearrangeAfterMerge-iwiz-Overhead.Min', 11692),
        ('RearrangeAfterMerge-iwiz.Min', 35778),
        ('RearrangeAfterMerge-rtmr-Overhead.Min', 440),
        ('RearrangeAfterMerge-rtmr.Min', 445),
        ('ReportPrinted.Min', 108368),
        ('RequestTime.Min', 809973),
        ('SearchTime.Min', 24297),
        ('SetupContextRule-Merge.Min', 2),
        ('UnanswersPercent.Min', 0.47822803926503904),
    ))

    result2 = dict((
        ('AllfactorsTime.Min', 0),
        ('CPUUsage.Min', 758031),
        ('CollectionsSerpData-Merge-iwiz.Min', 6),
        ('Dumper-Fetch-dgq.Min', 4),
        ('Dumper-Fetch-ii.Min', 3),
        ('Dumper-Fetch-iq.Min', 3),
        ('Dumper-Fetch-iwiz.Min', 3),
        ('Dumper-Fetch-rtmr.Min', 4),
        ('Dumper-Merge-dgq.Min', 4),
        ('Dumper-Merge-ii.Min', 3),
        ('Dumper-Merge-iq.Min', 3),
        ('Dumper-Merge-iwiz.Min', 5),
        ('Dumper-Merge-rtmr.Min', 5),
        ('ExtraMergeCycles.Min', 5),
        ('FetchTime.Min', 0),
        ('ImgFreshFilter-Merge-ii.Min', 4),
        ('ImgGroupingMerge-Merge-ii.Min', 1046),
        ('ImgSerpData-Merge-iwiz.Min', 24073),
        ('L4FormulaUpper-Fetch-ii.Min', 2),
        ('Merge.Min', 868),
        ('MetaSearchTime.Min', 785522),
        ('OtherTime.Min', 154),
        ('PrepareClients.Min', 132907),
        ('RearrangeAfterBlend-rtmr-Overhead.Min', 4),
        ('RearrangeAfterBlend-rtmr.Min', 4),
        ('RearrangeAfterBlenderFactors-iq-Overhead.Min', 3),
        ('RearrangeAfterBlenderFactors-iq.Min', 3),
        ('RearrangeAfterFetch-dgq-Overhead.Min', 596),
        ('RearrangeAfterFetch-dgq.Min', 600),
        ('RearrangeAfterFetch-ii-Overhead.Min', 7882),
        ('RearrangeAfterFetch-ii.Min', 7887),
        ('RearrangeAfterFetch-iq-Overhead.Min', 501),
        ('RearrangeAfterFetch-iq.Min', 504),
        ('RearrangeAfterFetch-iwiz-Overhead.Min', 718),
        ('RearrangeAfterFetch-iwiz.Min', 721),
        ('RearrangeAfterFetch-rtmr-Overhead.Min', 1284),
        ('RearrangeAfterFetch-rtmr.Min', 1288),
        ('RearrangeAfterIntentWeights-rtmr-Overhead.Min', 4),
        ('RearrangeAfterIntentWeights-rtmr.Min', 4),
        ('RearrangeAfterMerge-dgq-Overhead.Min', 3259),
        ('RearrangeAfterMerge-dgq.Min', 3263),
        ('RearrangeAfterMerge-ii-Overhead.Min', 3400),
        ('RearrangeAfterMerge-ii.Min', 4453),
        ('RearrangeAfterMerge-iq-Overhead.Min', 2239),
        ('RearrangeAfterMerge-iq.Min', 2242),
        ('RearrangeAfterMerge-iwiz-Overhead.Min', 11692),
        ('RearrangeAfterMerge-iwiz.Min', 35778),
        ('RearrangeAfterMerge-rtmr-Overhead.Min', 440),
        ('RearrangeAfterMerge-rtmr.Min', 445),
        ('ReportPrinted.Min', 108368),
        ('RequestTime.Min', 809973),
        ('SearchTime.Min', 24297),
        ('SetupContextRule-Merge-iwiz.Min', 2),
        ('UnanswersPercent.Min', 0.47822803926503904),
    ))

    def test1(self):
        options = evlogstat.Options()
        options.process_count = 2
        options.mode = 'blender'
        options.by_grouping = False
        options.stat_names = ['Min']

        full_stat = self._do(options)

        assert sorted(full_stat.keys()) == sorted(self.result1.keys()), 'keys are different: {}'.format(
            set(full_stat.keys()) ^ set(self.result1.keys())
        )
        val_diff = False
        for k, v in full_stat.iteritems():
            if v != self.result1[k]:
                print '\nvalues are different ({}): {} -> {}'.format(k, self.result1[k], v)
                val_diff = True
        assert not val_diff, 'some values are different'

    def test2(self):
        options = evlogstat.Options()
        options.process_count = 2
        options.mode = 'blender'
        options.by_grouping = True
        options.stat_names = ['Min']

        full_stat = self._do(options)

        assert sorted(full_stat.keys()) == sorted(self.result2.keys()), 'keys are different: {}'.format(
            set(full_stat.keys()) ^ set(self.result2.keys())
        )
        val_diff = False
        for k, v in full_stat.iteritems():
            if v != self.result2[k]:
                print 'values are different ({}): {} -> {}'.format(k, self.result2[k], v)
                val_diff = True
        assert not val_diff, 'some values are different'

    @staticmethod
    def _do(options):
        calc = evlogstat.StatCalc(options)
        with open('test_evlog_1.txt') as in_f:
            calc.parse_eventlog(in_f)
            # calc.dump(sys.stdout)
        full_stat = calc.get_full_stat()
        # print json.dumps(full_stat, indent=4)
        # print json.dumps(sorted([str((k, v)) for k, v in full_stat.iteritems()]), indent=4)
        return full_stat


if __name__ == '__main__':
    unittest.main()
