# -*- coding: utf-8 -*-

from sandbox import sdk2


class Component(object):
    class Parameters(sdk2.Parameters):
        """
            Required input parameters for task
        """

    def __init__(self, parameters, port):
        """
            :parameters: task's input parameters
        """
        pass

    def _sync_resource(self, resource):
        return sdk2.ResourceData(resource)

    @staticmethod
    def name():
        """
            Name of the component
        """
        raise NotImplementedError()

    def binary_path(self):
        """
            Get binary path
        """
        raise NotImplementedError()

    def data_paths(self):
        """
            Get list of directories with data
        """
        raise NotImplementedError()

    def execution_arguments(self):
        """
            Get arguments for component start.
            (e.g. ['-d', 'apache.ywsearch.cfg'] for Noapache)
        """
        raise NotImplementedError()

    def ready_for_first_request(self):
        """
            Checks whether instance is ready to receive the first request
        """
        raise NotImplementedError()

    def send_request(self):
        """
            Sends request to instance
        """
        raise NotImplementedError()

    def stop(self):
        """
            Stops instance
        """
        raise NotImplementedError()
