import argparse
import json
import logging
import psutil


def io_counters():
    parser = argparse.ArgumentParser(description="Get io counters for process")
    parser.add_argument("-p", "--pid", help="Process pid", type=int, required=True)
    args = parser.parse_args()
    logging.debug("Psutil version: {}".format(psutil.__version__))
    print(json.dumps(dict(psutil.Process(args.pid).io_counters()._asdict()), indent=2))


if __name__ == '__main__':
    io_counters()
