# -*- coding: utf-8 -*-

from sandbox.projects.websearch.PerlReportBase import PerlReportBase as PerlReportBase

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.report import common as rc
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.common.types.resource import State


class PerlReport2Base(PerlReportBase):

    class Context(PerlReportBase.Context):
        pr2 = {
            "root_folder": "arkanavt.2",
        }

    class Parameters(PerlReportBase.Parameters):
        pr2_label = "justapache #2"
        with sdk2.parameters.Group("PerlReport: {label}".format(label = pr2_label)) as pr2_second_pr_group:
            with sdk2.parameters.RadioGroup("Source:") as pr2_source:
                pr2_source.values['svn'] = pr2_source.Value(default=True)
                pr2_source.values['sb_resource'] = None
                with pr2_source.value['svn']:
                    pr2_svn_url = sdk2.parameters.ArcadiaUrl(
                        "Arcadia URL for perl report:",
                        default_value = Arcadia.trunk_url() + '/web/report/@HEAD',
                    )
                with pr2_source.value['sb_resource']:
                    pr2_sb_resource = sdk2.parameters.Resource(
                        "Sandbox resource with perl report:",
                        resource_type = resource_types.REPORT_CORE_PACKAGE,
                        required = True,
                    )

            pr2_apache_bundle = sdk2.parameters.Resource(
                "Apache bundle",
                resource_type = resource_types.APACHE_BUNDLE,
                required = True,
            )
            pr2_data_runtime = sdk2.parameters.Resource(
                "DataRuntime",
                resource_type = resource_types.WEB_REPORT_DATA_RUNTIME_BUNDLE,
                required = True,
            )
            pr2_sdch_dictionary = sdk2.parameters.Resource(
                "SDCH dictionary",
                resource_type = rc.SdchWebDictionaryPack,
                required = True,
            )
            pr2_rtcc_bundle = sdk2.parameters.Resource(
                "Config for upper",
                resource_type = resource_types.RTCC_BUNDLE,
                required = True,
            )
            pr2_report_templates = sdk2.parameters.Resource(
                "Report templates",
                resource_type = resource_types.REPORT_TEMPLATES_PACKAGE,
                required = True,
            )

            pr2_port = sdk2.parameters.Integer(
                "PerlReport port",
                required = True,
                default = 8082
            )
            pr2_env = sdk2.parameters.String(
                "ENV param(key1=val1 key2=val2 ...)",
                required = True,
                default = "IS_BETA=1 MAX_CLIENTS=4 REPORT_INVERTED=1"
            )
            pr2_addition_flags_json = sdk2.parameters.JSON(
                'Addition PerlReport flags, JSON: ARRAY of OBJECTS e.g. [{"taxi_form":0}]',
                required = False,
                default_value = [{}]
            )
            pr2_request_json_url = sdk2.parameters.Url(
                'URL of alternative request.json e.g. http://apphost.priemka.yandex.ru/viewconfig?name=request.json',
                required = False,
                default_value = None
            )
            pr2_flags_json_url = sdk2.parameters.Url(
                'URL of alternative Experiments 100% flags.json e.g. https://ab.yandex-team.ru/deploying/flags.json/2/content',
                required = False,
                default_value = None
            )

    def on_create(self):

        PerlReportBase.on_create(self)

        self.Parameters.pr2_sb_resource = sdk2.Resource.find(
            resource_type = resource_types.REPORT_CORE_PACKAGE,
            attrs = { "released": "stable" },
            state=(State.READY)
        ).first()

        self.Parameters.pr2_apache_bundle = sdk2.Resource.find(
            resource_type = resource_types.APACHE_BUNDLE,
            attrs = { "released": "stable" },
            state=(State.READY)
        ).first()

        self.Parameters.pr2_data_runtime = sdk2.Resource.find(
            resource_type = resource_types.WEB_REPORT_DATA_RUNTIME_BUNDLE,
            attrs = { "released": "stable" },
            state=(State.READY)
        ).first()

        self.Parameters.pr2_sdch_dictionary = sdk2.Resource.find(
            resource_type = rc.SdchWebDictionaryPack,
            attrs = { "released": "stable" },
            state = (State.READY)
        ).first()

        self.Parameters.pr2_rtcc_bundle = sdk2.Resource.find(
            resource_type = resource_types.RTCC_BUNDLE,
            attrs = { "released": "stable" },
            state = (State.READY)
        ).first()

        self.Parameters.pr2_report_templates = sdk2.Resource.find(
            resource_type = resource_types.REPORT_TEMPLATES_PACKAGE,
            attrs = { "released": "stable" },
            state = (State.READY)
        ).first()

    def ctx2(self) :
        return {
            "root_folder": self.Context.pr2["root_folder"],
            "label": self.Parameters.pr2_label,
            "pr_source": self.Parameters.pr2_source,
            "svn_url": self.Parameters.pr2_svn_url,
            "sb_resource": self.Parameters.pr2_sb_resource,
            "apache_bundle": self.Parameters.pr2_apache_bundle,
            "data_runtime": self.Parameters.pr2_data_runtime,
            "sdch_dictionary": self.Parameters.pr2_sdch_dictionary,
            "rtcc_bundle": self.Parameters.pr2_rtcc_bundle,
            "report_templates": self.Parameters.pr2_report_templates,
            "port": self.Parameters.pr2_port,
            "env": self.Parameters.pr2_env,
            "addition_flags_json": self.Parameters.pr2_addition_flags_json,
            "request_json_url": self.Parameters.pr2_request_json_url,
            "flags_json_url": self.Parameters.pr2_flags_json_url
        }

    def on_execute(self):
        PerlReportBase.on_execute(self)
        self.kill_port = '18882'
        self.setup_perl_report_to(self.ctx2())
