# -*- coding: utf-8 -*-
import os
import logging
from sandbox.projects.common.build.KosherYaMake import KosherYaMake
from sandbox.projects.release_machine.helpers import soy_helper
from sandbox import sdk2
from sandbox.sdk2 import paths


class SearchIntegrationTests2(KosherYaMake):
    """
        KosherYaMake c переопределенными методами on_timeout, on_break
        тесты запускают soy скачку, в случае проблем надо отменить скачку.
    """

    class Parameters(KosherYaMake.Parameters):
        tokens = sdk2.parameters.YavSecret(
            "YAV secret identifier (with optional version)",
            default="sec-01f3dnxszdxw71xyv8fszr22hy"
        )

    def _soy_token(self):
        tokens = self.Parameters.tokens.data()
        return tokens["SOY_TOKEN"]

    def _soy_batch_path(self):
        return str(self.log_path('.soy_batch'))

    def _abort_soy_batch(self):
        dest = self._soy_batch_path()
        for name in os.listdir(dest):
            file_path = os.path.join(dest, name)
            if os.path.isfile(file_path):
                with open(file_path, 'r') as r:
                    soy_id = r.readline().strip()
                    if soy_id:
                        logging.info("Aborting soy batch: {}".format(soy_id))
                        soy_api = soy_helper.SoyApi(token=self._soy_token())
                        res = soy_api.abort(soy_id)
                        logging.info("Abortion status: {}".format(res.get("status")))
                        if "error_msg" in res:
                            logging.error(res["error_msg"])

    def on_failure(self, prev_status):
        self._abort_soy_batch()
        super(SearchIntegrationTests2, self).on_failure(prev_status)

    def on_timeout(self, prev_status):
        self._abort_soy_batch()
        super(SearchIntegrationTests2, self).on_timeout(prev_status)

    def on_break(self, *args, **kwargs):
        self._abort_soy_batch()
        super(SearchIntegrationTests2, self).on_break(*args, **kwargs)

    def on_terminate(self):
        self._abort_soy_batch()
        super(SearchIntegrationTests2, self).on_terminate()

    def on_execute(self):
        # создаем директорию в которую тесты запишут soyid
        paths.make_folder(self._soy_batch_path(), delete_content=True)
        # говорим тестам куда записать soyid
        os.environ["PATH_TO_SOY_BATCH"] = self._soy_batch_path()

        super(SearchIntegrationTests2, self).on_execute()
