# -*- coding: utf-8 -*-

import logging
import json
from sandbox import sdk2
from sandbox.common import errors


class SearchIntegrationTestsFlaky(sdk2.Task):
    """
        Находит N последних ресурсов с флапающими интеграционными тестами и выдает сводку
    """

    class Parameters(sdk2.Task.Parameters):
        count = sdk2.parameters.Integer(
            'Number of last FlakySearchIntegration resources',
            required=True,
            default_value=20
        )

    def on_execute(self):
        if self.Parameters.count <=0 or self.Parameters.count > 200:
            raise errors.TaskFailure("Param count in [1, 200]")

        resources = sdk2.Resource["FLAKY_SEARCH_INTEGRATION"].find(state="READY").limit(self.Parameters.count)
        logging.info("Find resources: {}".format(resources))

        stat = {}
        for res in resources:
            data = sdk2.ResourceData(res)
            json_data = None
            with open(str(data.path)) as fh:
                json_data = json.load(fh)
                for (path, names) in json_data.iteritems():
                    if path not in stat:
                        stat[path] = {}
                    for name in names:
                        if name not in stat[path]:
                            stat[path][name] = 0
                        stat[path][name] += 1

        resource = sdk2.Resource["TASK_CUSTOM_LOGS"](self, self.Parameters.description, "stat.json")
        resource.path.write_bytes(json.dumps(stat))
