import os
from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.websearch.basesearch.resources as bs_res


class BuildTestShard(YaMakeTask):
    """
        Build test_shard binary
    """

    type = 'BUILD_TEST_SHARD'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
    ]

    resources = [
        bs_res.TestShardBinary
    ]

    def get_targets(self):
        return [
            r.arcadia_build_path for r in self.resources
        ]

    def get_resources(self):
        resources = {}
        for r in self.resources:
            resources[r.name] = {
                'description': r.name,
                'resource_type': r,
                'resource_path': os.path.basename(r.arcadia_build_path),
            }
        return resources

    def get_arts(self):
        return [
            {'path': r.arcadia_build_path} for r in self.resources
        ]
