from sandbox import sdk2
from sandbox.projects.common import decorators
from sandbox.projects.common import task_env
from sandbox.projects.common import utils
from sandbox.projects.common import time_utils as tu
from sandbox.projects.common import error_handlers as eh
from sandbox.projects import resource_types


DB_TYPES = [
    'PlatinumTier0',
]


class GetBasesearchConfig2(sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        tasks_resource = sdk2.Task.Requirements.tasks_resource(default=2758666412)

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.CheckGroup("DB types") as db_types:
            db_types.choices = [(_, _) for _ in DB_TYPES]

    def on_enqueue(self):
        load_time = tu.date_ymd(sep="_")

        for db_type in self.Parameters.db_types:
            resource = resource_types.SEARCH_CONFIG(self, 'Basesearch {} prod config. {}'.format(db_type, load_time), 'basesearch_{}.cfg'.format(db_type))
            setattr(resource, "TE_web_base_prod_resources_{}".format(db_type), load_time)
            setattr(self.Context, 'search_config_for_{}'.format(db_type), resource.id)

    def on_execute(self):
        for db_type in self.Parameters.db_types:
            endpoints = get_endpoints(db_type)
            for fqdn, port in endpoints:
                path = str(sdk2.ResourceData(sdk2.Resource[getattr(self.Context, 'search_config_for_{}'.format(db_type))]).path)
                utils.get_config_by_info_request(fqdn, port, path)
                break


def get_endpoints(db_type):
    try:
        from infra.yp_service_discovery.python.resolver.resolver import Resolver
        from infra.yp_service_discovery.api import api_pb2
        resolver = Resolver(client_name='GetBasesearchConfig', timeout=60)
        request = api_pb2.TReqResolveEndpoints()
        request.cluster_name = 'sas'
        request.endpoint_set_id = 'sas-web-search.platinum-base-2'  # todo: use db_type here?
        for endpoint in _resolve_single_cluster_endpoints(resolver, request).endpoint_set.endpoints:
            yield endpoint.fqdn, endpoint.port
    except Exception as e:
        eh.log_exception("Failed to get instance from SD", e)


@decorators.retries(3)
def _resolve_single_cluster_endpoints(resolver, request):
    return resolver.resolve_endpoints(request)
