# -*- coding: utf-8 -*-

import logging

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter

from sandbox.projects.common.BaseGetDatabaseTask import DatabaseRsyncPath
from sandbox.projects.common.BaseGetDatabaseTask import CheckDbState
from sandbox.projects.common.BaseGetDatabaseTask import DatabaseType
from sandbox.projects.common import utils
from sandbox.projects.websearch.basesearch.GetBasesearchDatabase import CheckSpamState


class ListOfDbLinks(SandboxStringParameter):
    name = 'list_of_db_links'
    description = 'List of rsync links for databases'
    multiline = True


class DatabaseAttr(SandboxStringParameter):
    """
        Добавить атрибуты к созданному ресурсу шарда (формат: attr1=v1, attr2=v2)
        Копируем ресурсы по-умолчанию
    """
    name = 'resource_attrs'
    description = 'Add attributes to the created db resource (ex.: attr1=v1, attr2=v2)'
    do_not_copy = False
    default_value = ''


class GetBasesearchDatabases(SandboxTask):
    type = 'GET_BASESEARCH_DATABASES'

    input_parameters = (DatabaseType, ListOfDbLinks, DatabaseAttr)

    def on_execute(self):
        if not self.list_subtasks():
            list_of_db = self.ctx.get(ListOfDbLinks.name, '').split('\n')
            for db_path in list_of_db:
                db_path = db_path.strip()
                logging.info('get db form url: %s', db_path)
                self._create_get_base_db_task(db_path)
            utils.wait_all_subtasks_stop()
        elif not utils.check_all_subtasks_done():
            utils.restart_broken_subtasks()
        else:
            utils.check_subtasks_fails(stop_on_broken_children=True)

    def _create_get_base_db_task(self, db_path):
        sub_ctx = {
            DatabaseType.name: self.ctx.get(DatabaseType.name, 'oxygen'),
            DatabaseRsyncPath.name: db_path,
            DatabaseAttr.name: self.ctx.get(DatabaseAttr.name, ''),
            CheckDbState.name: False,
            CheckSpamState.name: False,
            'kill_timeout': 18000  # 5 hours
        }

        self.create_subtask(
            task_type='GET_BASESEARCH_DATABASE',
            description='{}, download basesearch database using path "{}"'.format(
                self.descr, db_path
            ),
            input_parameters=sub_ctx
        )


__Task__ = GetBasesearchDatabases
