import sandbox.common.types.client as ctc
from sandbox import sdk2

import sandbox.projects.common.search.components.mkl as sc_mkl
from sandbox.projects import resource_types
from sandbox.projects.common.search import bugbanner2
from sandbox.projects.common.search import requester_mixin
from sandbox.projects.websearch.basesearch import components
from sandbox.projects.websearch.basesearch import params as bs_params


class GetWebBasesearchResponses(requester_mixin.SearchRequesterTask):
    """
       Task for getting responses from local web basesearch
    """
    class Requirements(sdk2.Task.Requirements):
        ram = 60 * 1024
        disk_space = 30 * 1024  # 30 Gb
        client_tags = ctc.Tag.GENERIC

    class Parameters(requester_mixin.SearchRequesterTask.Parameters):
        basesearch = bs_params.SingleBasesearchParameters

    def on_execute(self):
        self.add_bugbanner(bugbanner2.Banners.WebBaseSearch)
        wbs = components.WebBasesearch(
            self,
            binary=self.Parameters.basesearch.executable,
            config=self.Parameters.basesearch.config,
            models=self.Parameters.basesearch.models_archive,
            database=self.Parameters.basesearch.database,
            polite_mode=self.Parameters.basesearch.polite_mode,
            # patch_request_threads=self.Parameters.basesearch.patch_request_threads,
        )
        sc_mkl.configure_mkl_environment(wbs)
        output_responses = resource_types.BASESEARCH_HR_RESPONSES(
            self, "Basesearch responses, {}".format(self.Parameters.description.encode("utf-8")),
            "basesearch_responses.txt"
        )
        with wbs:
            self.save_responses(
                wbs.port,
                str(sdk2.ResourceData(output_responses).path),
            )
