# -*- coding: utf-8 -*-

from sandbox.projects.websearch.basesearch.TestBasesearchPerformance import TestBasesearchPerformance
from sandbox.projects.common import sanitizer
from sandbox.projects.common.search import components as sc

AddressSanitized = sanitizer.generate_task(
    sc.DefaultBasesearchParams,
    TestBasesearchPerformance,
    start_timeout=sc.DEFAULT_START_TIMEOUT * 2)


class SanitizeBasesearch(AddressSanitized):
    """
        Запускает долбёжку базового поиска (собранного с Address Sanitizer) на производительность (типа, stress test).
        Тюнит некоторые параметры конфига, чтобы побыстрее стартовало. Смотрит, упадёт или нет.
    """
    type = 'SANITIZE_BASESEARCH'
    execution_space = 38 * 1024  # 38 Gb max usage is ~33 Gb


__Task__ = SanitizeBasesearch
