from sandbox.sandboxsdk import sandboxapi

from sandbox.projects.common.search import components as sc
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.common.search import yasm as search_yasm
from sandbox.projects.common.search.basesearch import task as search_task
from sandbox.projects.websearch.basesearch import TestBasesearchPerformance as tbp
from sandbox.projects import resource_types

_INSTANCE_TYPE = "base"
_INSTANCE_TAG = (
    ("ctype", "prod"),
    ("geo", "msk"),
    ("prj", "web-base"),
    ("tier", "yandsearch"),
)


class WebTestBasesearchUnistat(
    search_performance.OldShootingTask, search_yasm.YasmAgentTask, search_task.BasesearchComponentTask
):
    """
        Verify unistat implementation in web basesearch
    """
    type = 'WEB_TEST_BASESEARCH_UNISTAT'
    client_tags = search_performance.OldShootingTask.client_tags & search_task.BasesearchComponentTask.client_tags
    input_parameters = (
        sc.DefaultBasesearchParams.params + (tbp.PlanParameter,) +
        search_task.BasesearchComponentTask.basesearch_input_parameters +
        search_performance.OldShootingTask.shoot_input_parameters +
        search_yasm.YasmAgentTask.input_parameters
    )

    def on_enqueue(self):
        search_task.BasesearchComponentTask.on_enqueue(self)
        self.create_resource(
            self.descr,
            self.__unistat_signals(),
            resource_types.BASESEARCH_UNISTAT_SIGNALS,
            arch=sandboxapi.ARCH_ANY
        )

    def on_execute(self):
        basesearch = self._basesearch(sc.DefaultBasesearchParams)
        yasmagent = self._yasmagent(basesearch, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        yasmlistener = self._yasmlistener(yasmagent, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)

        self._init_virtualenv()
        with basesearch, yasmagent, yasmlistener:
            self._old_shoot(basesearch, self.ctx[tbp.PlanParameter.name])
        yasmlistener.dump(self.__unistat_signals())

    def __unistat_signals(self):
        return self.abs_path("unistat-signals.txt")


__Task__ = WebTestBasesearchUnistat
