from sandbox import sdk2

from sandbox.projects import resource_types
import sandbox.projects.websearch.params as ws_params


class DefaultTestenvProdResource(ws_params.ResourceWithDefaultByAttr):
    default_attr_name = "TE_web_base_prod_resources_PlatinumTier0"


def basesearch_executable(suffix=""):
    return sdk2.parameters.LastReleasedResource(
        "Basesearch executable" + suffix,
        resource_type=resource_types.BASESEARCH_EXECUTABLE,
        required=False,
    )


def basesearch_config(suffix=""):
    return DefaultTestenvProdResource(
        "Basesearch config" + suffix,
        resource_type=resource_types.SEARCH_CONFIG,
    )


def basesearch_models_archive(suffix=""):
    return sdk2.parameters.LastReleasedResource(
        "Basesearch models archive" + suffix,
        resource_type=resource_types.DYNAMIC_MODELS_ARCHIVE_BASE,
        required=False,
    )


def basesearch_database(suffix=""):
    """Does not provide coherence between default database and requests"""
    return DefaultTestenvProdResource(
        "Basesearch database" + suffix,
        resource_type=resource_types.SEARCH_DATABASE,
    )


class SingleBasesearchParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Web basesearch parameters") as web_basesearch_params:
        executable = basesearch_executable()
        config = basesearch_config()
        models_archive = basesearch_models_archive()
        database = basesearch_database()
        polite_mode = sdk2.parameters.Bool("Polite mode", default=True)
        patch_request_threads = sdk2.parameters.Bool("Patch request threads", default=True)


SUFFIX1, SUFFIX2 = " 1", " 2"


class DoubleBasesearchParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Web basesearch parameters" + SUFFIX1) as web_basesearch_params1:
        executable1 = basesearch_executable(SUFFIX1)
        config1 = basesearch_config(SUFFIX1)
        models_archive1 = basesearch_models_archive(SUFFIX1)
        database1 = basesearch_database(SUFFIX1)
        polite_mode1 = sdk2.parameters.Bool("Polite mode", default=True)
        patch_request_threads1 = sdk2.parameters.Bool("Patch request threads", default=True)

    with sdk2.parameters.Group("Web basesearch parameters" + SUFFIX2) as web_basesearch_params2:
        executable2 = basesearch_executable(SUFFIX2)
        config2 = basesearch_config(SUFFIX2)
        models_archive2 = basesearch_models_archive(SUFFIX2)
        database2 = basesearch_database(SUFFIX2)
        polite_mode2 = sdk2.parameters.Bool("Polite mode", default=True)
        patch_request_threads2 = sdk2.parameters.Bool("Patch request threads", default=True)
