from sandbox import sdk2
from sandbox.projects.resource_types import releasers


class EmbeddingStorageExecutable(sdk2.Resource):
    """
        Embedding Storage Executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.base_releasers
    arcadia_build_path = 'search/base_search/daemons/embedding_storage/embedding_storage'
    arcadia_build_name = 'embedding_storage'


class InvertedIndexStorageExecutable(sdk2.Resource):
    """
        Inverted Index Storage Executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.base_releasers
    arcadia_build_path = 'search/base_search/daemons/inverted_index_storage/inverted_index_storage'
    arcadia_build_name = 'inverted_index_storage'


class RemoteStorageExecutable(sdk2.Resource):
    """
        Remote Storage Executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.base_releasers
    arcadia_build_path = 'search/base_search/daemons/remote_storage/remote_storage'
    arcadia_build_name = 'remote_storage'


class BertMmetaExecutable(sdk2.Resource):
    """
        Bert Mmeta Executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.base_releasers
    arcadia_build_path = 'search/base_search/daemons/bert/bert'


class BertMmetaModelsArchive(sdk2.Resource):
    """
        Bert Mmeta Models Archive
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = releasers.base_releasers

class KeyInvServiceExecutable(sdk2.Resource):
    """
        KeyInv executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.base_releasers
    arcadia_build_path = 'search/base_search/daemons/keyinv/keyinv'


class TestShardBinary(sdk2.Resource):
    """
        test_shard binary (from search/tools/test_shard)
    """
    any_arch = False
    executable = True
    releasable = True
    arcadia_build_path = 'search/tools/test_shard/test_shard'


class TestShardPlainQueries(sdk2.Resource):
    """
        Plain queries in prs_ops format
    """


class TestShardConfig(sdk2.Resource):
    """
        test_shard config used in request generation
    """


class EmbeddingTestRequests(sdk2.Resource):
    """
        Requests for test embedding storage
    """


class DYNAMIC_MODELS_ARCHIVE_L1(sdk2.Resource):
    """
        Dynamic models for web l1 intsearch
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = releasers.all_dynamic_models_releasers


class DYNAMIC_MODELS_ARCHIVE_SHMICK_BASE(sdk2.Resource):
    """
        Dynamic models for shmick base
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = releasers.all_dynamic_models_releasers


class BasesearchShard(sdk2.Resource):
    """
        Directory with basesearch shard
    """
    pass


class BasesearchTextPlan(sdk2.Resource):
    """
        Human-readable basesearch plan
    """
    pass


class BasesearchDolbiloPlan(sdk2.Resource):
    """
        Basesearch plan in dolbilo format
    """
    pass


class EventLogDataGrabber(sdk2.Resource):
    """
        EventLogData grabber tool
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = releasers.base_releasers
    arcadia_build_path = 'search/tools/eventlogdata_grabber/eventlogdata_grabber'
