import itertools

from sandbox.projects.websearch.begemot.common import BegemotAllServices
from sandbox.projects.websearch.upper.resources import FastDataDeployer
from sandbox.projects.websearch.begemot import resources
from sandbox.projects import resource_types as rt


class BegemotAllServicesWithRes(BegemotAllServices):
    def __init__(self):
        super(BegemotAllServicesWithRes, self).__init__()
        for svc in self.Service.values():
            svc.add_res(resources)


AllBegemotServices = BegemotAllServicesWithRes()

BW_RESOURCES = {
    'BegemotExecutable': [
        resources.BEGEMOT_EXECUTABLE,
        resources.BEGEMOT_ADVQ_EXECUTABLE,
        resources.BEGEMOT_ANTIROBOT_EXECUTABLE,
        resources.BEGEMOT_BERT_EXECUTABLE,
        resources.BEGEMOT_GEO_EXECUTABLE,
        resources.BEGEMOT_LOGGER_EXECUTABLE,

        resources.BEGEMOT_EVLOGDUMP,
        resources.BEGEMOT_EVLOG_UPLOADER,
        resources.BEGEMOT_YT_EVENTLOG_MAPPER,
        resources.BEGEMOT_YT_MAPPER,
        resources.BEGEMOT_FAST_BUILD_DOWNLOADER,
        resources.BEGEMOT_ARGUMENTS_PARSER,
        resources.BEGEMOT_SHARD_UPDATER,
        resources.BEGEMOT_EVLOGDUMP_FOR_UNIFIED_AGENT,
    ],
    'BegemotConfig': [resources.BEGEMOT_CONFIG],
    'AdvqExecutable': [
        resources.BEGEMOT_ADVQ_EXECUTABLE,
        resources.BEGEMOT_EVLOGDUMP,
        resources.BEGEMOT_EVLOG_UPLOADER,
        resources.BEGEMOT_FAST_BUILD_DOWNLOADER,
        resources.BEGEMOT_ARGUMENTS_PARSER,
    ],
    'MegamindExecutable': [
        resources.BEGEMOT_MEGAMIND_EXECUTABLE,
        resources.BEGEMOT_EVLOGDUMP,
        resources.BEGEMOT_EVLOG_UPLOADER,
        resources.BEGEMOT_FAST_BUILD_DOWNLOADER,
        resources.BEGEMOT_ARGUMENTS_PARSER,
    ],
    'BegginsExecutable': [
        resources.BEGEMOT_BEGGINS_EXECUTABLE,
    ],
    'BegginsExecutableAddons': [
        resources.BEGEMOT_EVLOGDUMP,
        resources.BEGEMOT_EVLOG_UPLOADER,
        resources.BEGEMOT_FAST_BUILD_DOWNLOADER,
        resources.BEGEMOT_ARGUMENTS_PARSER,
    ],
    'RequestInitExecutable': [
        resources.BEGEMOT_REQUEST_INIT_EXECUTABLE,
        resources.BEGEMOT_EVLOGDUMP,
        resources.BEGEMOT_EVLOG_UPLOADER,
        resources.BEGEMOT_FAST_BUILD_DOWNLOADER,
        resources.BEGEMOT_ARGUMENTS_PARSER,
    ],
    'CaesarModelsExecutable': [
        resources.BEGEMOT_CAESAR_MODELS_EXECUTABLE,
        resources.BEGEMOT_EVLOGDUMP,
    ],
    'WizardRuntime': [
        rt.WIZARD_RUNTIME_PACKAGE,
        rt.WIZARD_RUNTIME_PACKAGE_UNPACKED,
    ],
    'BegemotFresh': list(itertools.chain.from_iterable([
        (s.fresh_data_resource_type, s.fresh_data_resource_packed_type)
        for s in AllBegemotServices.Service.values()
        if s.release_fresh
    ])),
    'BegemotFreshFastBuild': [
        s.fresh_fast_build_config_resource_type
        for s in AllBegemotServices.Service.values()
        if s.release_fresh
    ],
    'BegemotFreshFastBuildCommon': [
        resources.BEGEMOT_FAST_BUILD_FRESH_CONFIG,
    ],
    'Bstr': [
        resources.BEGEMOT_BSTR,
        resources.BEGEMOT_BSTR_PUSHER,
        resources.BEGEMOT_BSTR_CALLER,
        resources.BEGEMOT_FAST_DATA_CALLBACK,
    ],
    'EventsFiles': [
        resources.BEGEMOT_PROTO_EVENTS,
        resources.BEGEMOT_PROTO_DESCRIPTOR,
        resources.BEGEMOT_PROTO_EVENTS_EXTENSION,
    ],
    'NannyConfigs': [
        resources.BEGEMOT_INSTANCECTL_CONF,
        resources.BEGEMOT_PUSHCLIENT_CONF
    ],
}
