import os
import subprocess
import json
import logging


def exclude_deps(deps_tree, exclude):
    while exclude:
        path = exclude[0]
        logging.debug("FAST BUILD: Dependency hasher excludes path {}".format(path))
        if path in deps_tree:
            for next_path in deps_tree[path]:
                exclude.append(next_path)
        deps_tree.pop(path, None)
        for node in deps_tree:
            while path in deps_tree[node]:
                deps_tree[node].remove(path)

        while path in exclude:
            exclude.remove(path)


def get_deps_tree(arcadia_path, target_path, exclude=[], additional_exclude=[u'build/scripts'], additional_flags=""):
    exclude = exclude + additional_exclude
    args = [
        os.path.join(arcadia_path, "ya"),
        "dump",
        "dir-graph",
        os.path.join(arcadia_path, target_path)
    ]
    if additional_flags:
        args += [additional_flags]
    command_pipe = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=subprocess.PIPE)

    out, err = command_pipe.communicate()
    returncode = command_pipe.poll()

    if int(returncode) != 0:
        logging.error("FAST BUILD: ya dump dir-graph err: {}".format(err.decode('utf-8')))
        raise Exception("Failed ya dump. Check debug.log for err")

    deps_tree = json.loads(out)
    exclude_deps(deps_tree, exclude)
    logging.debug("FAST BUILD: deps tree is {}".format(deps_tree))
    return deps_tree
