import json
import os
import shutil

from sandbox import sdk2
from sandbox.common.config import Registry
import sandbox.common.share as c_share
from sandbox.common.types.misc import Installation


class ShardSyncHelper:

    def __init__(self, fast_build_config_resource=None, sdk1_task=None):
        self.fast_build_config_resource = fast_build_config_resource
        self.sdk1_task = sdk1_task

    def get_shard_size(self):
        return int(self.fast_build_config_resource.data_size_kb) * 1024

    def shard_type_is(self, *types):
        return self.fast_build_config_resource.type in types

    def _sync_resource(self, resource):
        if self.sdk1_task:
            return self.sdk1_task.sync_resource(resource)
        else:
            if type(resource) is int:
                resource = sdk2.Resource.find(id=resource).first()
            return str(sdk2.ResourceData(resource).path)

    def sync_shard(self, shard_path="data", add_relev=False):
        if not os.path.exists(shard_path):
            os.makedirs(shard_path)

        config_path = self._sync_resource(self.fast_build_config_resource)
        with open(config_path) as config_file:
            config = json.load(config_file)

        for rule in config['resources']:
            if Registry().common.installation == Installation.LOCAL:
                c_share.skynet_get(rule['torrent'], shard_path)
            else:
                rule_path = self._sync_resource(int(rule['resource_id']))
                new_rule_path = os.path.join(shard_path, rule['name'])
                shutil.copytree(rule_path, new_rule_path)

        def safe_mkdir(path):
            try:
                os.mkdir(path)
            except OSError:
                pass

        if add_relev:
            # write reqid and relevs to begemot output (BEGEMOT-2409)
            for rule in ["RelevStrings", "Relevs", "SetInternalRelevs", "RelevWithoutQbungle", "Reqid"]:
                safe_mkdir(os.path.join(shard_path, rule))

        os.system("chmod -R a+w " + shard_path)

        return shard_path
