class QualityDiffViewer:
    METRICS = ("rec", "pr", "eff_pr")
    RESPONSE_TYPES = ("all", "sug10000")
    URL_TEMPLATE = "https://misspell.viewer.yandex-team.ru/typos/testres.py?test={test1}&cat=all&test2={test2}&dcat=dtotal"

    def __init__(self, prev_report_json, current_report_json, max_diff_to_skip=0.1):
        self.prev = prev_report_json["runs"]
        self.curr = current_report_json["runs"]
        self.max_diff_to_skip = max_diff_to_skip

    def get_tests_and_langs(self):
        tests = {(t[0], t[2]) for t in map(lambda s: s.split(), self.prev.keys())}
        tests.update({(t[0], t[2]) for t in map(lambda s: s.split(), self.curr.keys())})
        return list(tests)

    def get_report_key(self, test, response_type):
        return "{test_set} {response_type} {lang}".format(test_set=test[0],
                                                          response_type=response_type,
                                                          lang=test[1])

    def get_quality_diff_for_test(self, test):
        result = {t: dict() for t in self.RESPONSE_TYPES}
        result["lang"] = test[1]
        for response_type in self.RESPONSE_TYPES:
            report_key = self.get_report_key(test, response_type)
            for metric in self.METRICS:
                old_val = self.prev[report_key][metric]
                old_run_id = self.prev[report_key]["run_id"]
                new_val = self.curr[report_key][metric]
                new_run_id = self.curr[report_key]["run_id"]
                result[response_type][metric] = {"old": old_val,
                                                 "old_run_id": old_run_id,
                                                 "new": new_val,
                                                 "new_run_id": new_run_id,
                                                 "delta": new_val - old_val}
        return result

    def get_quality_diff_report(self):
        return {test[0]: self.get_quality_diff_for_test(test) for test in self.get_tests_and_langs()}

    def is_zerodiff(self):
        for test in self.get_tests_and_langs():
            diff = self.get_quality_diff_for_test(test)
            for response_type in self.RESPONSE_TYPES:
                v = diff[response_type]
                for metric, metric_diff in v.iteritems():
                    if abs(metric_diff["delta"]) > self.max_diff_to_skip:
                        return False
        return True
