from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common import constants as consts
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common import utils
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.channel import channel


class ReleaseBegemotToNanny(nanny.ReleaseToNannyTask):
    """Mixin for begemot nanny releases."""

    def on_release(self, additional_parameters):
        for r in self.list_resources():
            if r.type.releasable and not r.is_ready():
                raise RuntimeError('The resource {id} ({name}) to be released is in an invalid state {state}'.format(
                    id=r.id, name=r.type.name, state=r.state
                ))
        if additional_parameters['release_status'] == ReleaseStatus.STABLE:
            build_type = utils.get_or_default(self.ctx, build_params.BuildType)
            eh.ensure(
                build_type == consts.RELEASE_BUILD_TYPE,
                'trying to release binary compiled non in release mode: {}'.format(build_type)
            )
        if nanny.STARTREK_TICKET_IDS_KEY in additional_parameters:
            self.ctx[nanny.STARTREK_TICKET_IDS_KEY] = additional_parameters.get(nanny.STARTREK_TICKET_IDS_KEY, [])
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)

        fresh = set(self.ctx.get('target_fresh_types', []))
        for r in self.list_resources():
            ttl = 7 if r.type.name in fresh else 60
            channel.sandbox.set_resource_attribute(resource_id=r.id, attribute_name='ttl', attribute_value=ttl)
