# -*- coding: utf-8 -*-
from sandbox.projects.websearch.begemot import resources as br
from sandbox.projects.websearch.begemot import AllBegemotServices
from sandbox import sdk2


BegemotExecutableResource = sdk2.parameters.Resource(
    'Begemot binary',
    resource_type=br.BEGEMOT_EXECUTABLE,
    required=True
)

BegemotConfigResource = sdk2.parameters.Resource(
    'Begemot config and files needed for cgi requests',
    resource_type=br.BEGEMOT_CONFIG_WITH_CGI
)

ShardDataResource = sdk2.parameters.Resource(
    'Begemot shard',
    resource_type=[
        s.data_resource_type for s in AllBegemotServices.Service.itervalues()
        if s.data_resource_type is not None]
)

FastBuildConfigResource = sdk2.parameters.Resource(
    'Begemot shard fast build config',
    resource_type=[
        s.fast_build_config_resource_type for s in AllBegemotServices.Service.itervalues()
        if s.fast_build_config_resource_type is not None
    ]
)

FreshResource = sdk2.parameters.Resource(
    'Begemot fresh',
    resource_type=[
        s.fresh_data_resource_type for s in AllBegemotServices.Service.itervalues()
        if s.fresh_data_resource_type is not None
    ] + [
        s.fresh_fast_build_config_resource_type for s in AllBegemotServices.Service.itervalues()
        if s.fresh_fast_build_config_resource_type is not None
    ]
)

BegemotQueriesResource = sdk2.parameters.Resource(
    'Begemot queries',
    resource_type=[br.BEGEMOT_APPHOST_QUERIES, br.BEGEMOT_CGI_QUERIES, br.BEGEMOT_CGI_PLAN],
    required=True
)

BegemotEvlogdumpBinaryResource = sdk2.parameters.Resource(
    'Begemot evlogdump binary',
    resource_type=br.BEGEMOT_EVLOGDUMP,
    required=False
)


BegemotEvlogstatBinaryResource = sdk2.parameters.Resource(
    'Begemot evlogstat binary',
    resource_type=br.BEGEMOT_EVLOGSTAT,
    required=False
)


BegemotEventlogResource = sdk2.parameters.Resource(
    'Begemot eventlog',
    resource_type=br.BEGEMOT_EVENTLOG,
    required=False
)
