# -*- coding: utf-8 -*-
from sandbox.projects import resource_types
from sandbox.projects.common.wizard import resources as wr
from sandbox.projects.websearch.begemot import AllBegemotServices
from sandbox.projects.websearch.begemot import resources as br
from sandbox.sandboxsdk import parameters as sp


class BinaryParameter(sp.ResourceSelector):
    name = 'begemot_binary'
    description = 'Begemot binary'
    resource_type = br.BEGEMOT_EXECUTABLE
    required = True


class ConfigParameter(sp.ResourceSelector):
    name = 'begemot_config'
    description = 'Begemot config and files needed for cgi requests'
    resource_type = br.BEGEMOT_CONFIG_WITH_CGI
    required = True


class ShardParameter(sp.ResourceSelector):
    name = 'data'
    description = 'Begemot light shard'
    resource_type = [s.data_resource_type_test for s in AllBegemotServices.Service.itervalues() if s.data_resource_type_test is not None]
    required = False


class FastBuildConfigParameter(sp.ResourceSelector):
    name = 'fast_build_config'
    description = 'Begemot shard fast build config'
    resource_type = [s.fast_build_config_resource_type for s in AllBegemotServices.Service.itervalues() if s.fast_build_config_resource_type is not None]
    required = False


class FreshParameter(sp.ResourceSelector):
    name = 'fresh'
    description = 'Begemot fresh'
    resource_type = [s.fresh_data_resource_type for s in AllBegemotServices.Service.itervalues() if s.fresh_data_resource_type is not None]


class PlanParameter(sp.ResourceSelector):
    name = 'begemot_plan'
    description = 'Begemot plan'
    resource_type = [resource_types.PLAIN_TEXT_QUERIES, br.BEGEMOT_CGI_PLAN, br.BEGEMOT_APPHOST_QUERIES, wr.WizardQueries]
    required = True


class EvlogdumpParameter(sp.ResourceSelector):
    name = 'begemot_evlogdump'
    description = 'Begemot evlogdump binary'
    resource_type = br.BEGEMOT_EVLOGDUMP
