#! /usr/bin/python
# -*- coding: utf-8 -*-
import json
import yt.wrapper as yt
from sandbox.projects.websearch.begemot.tasks.BegemotCreateResponsesDiff import jsondiff


def remove_version(answer):
    if 'rules' in answer and '.version' in answer['rules']:
        answer['rules'].pop('.version', None)
    return answer


def split_diff(diff):
    if diff is None:
        return
    elif isinstance(diff, dict):
        for k, x in diff.items():
            for s in split_diff(x):
                yield (k,) + s[0], s[1]
    elif isinstance(diff, list):
        for i, x in enumerate(diff):
            for s in split_diff(x):
                yield ('*',) + s[0], s[1]
    elif isinstance(diff, jsondiff.Add):
        yield ('Add',), json.dumps(diff.value, ensure_ascii=False)
    elif isinstance(diff, jsondiff.Del):
        yield ('Del',), json.dumps(diff.value, ensure_ascii=False)
    elif isinstance(diff, jsondiff.Mod):
        yield ('Mod',), '%s -> %s' % (
            json.dumps(diff.old, ensure_ascii=False), json.dumps(diff.new, ensure_ascii=False)
        )


def full_diff(key, rows):
    a, b = rows.next(), rows.next()
    ans1 = remove_version(json.loads(a['begemot_answer'])[0])
    ans2 = remove_version(json.loads(b['begemot_answer'])[0])
    df = jsondiff.diff(ans1, ans2)
    if df is not None:
        text_diff = ''.join(jsondiff.render_text([(u'Begemot Answer 1', u'Begemot Answer 2', df)])).encode('utf-8')
        html_diff = "".join(jsondiff.render_html([(u"Begemot Answer 1", u"Begemot Answer 2", df)])).encode('utf-8')
        yield yt.create_table_switch(0)
        yield {
            'begemot_answer_1': a['begemot_answer'], 'begemot_answer_2': b['begemot_answer'],
            'diff': text_diff, 'reqid': key['reqid'], 'htmlDiff': html_diff,
        }
        yield yt.create_table_switch(1)
        for path, d in split_diff(df):
            yield {'reqid': key['reqid'], 'path': '.'.join(path), 'diff': d}


def group(key, diffs):
    diff = next(diffs)['diff']
    count = 1
    for _ in diffs:
        count += 1
    yield {'path': key['path'], 'diff': diff, 'count': count}
