# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.websearch.begemot import resources as br


class BegemotFailCacheHitDiff(sdk2.Task):
    '''
    Get failcache hit diff
    '''
    class Parameters(sdk2.Task.Parameters):
        failcache_hit_1 = sdk2.parameters.Resource(
            'First failcache hit to compare',
            resource_type=br.BEGEMOT_FAILCACHE_HIT_RESULT,
            required=True
        )
        failcache_hit_2 = sdk2.parameters.Resource(
            'Second failcache hit to compare',
            resource_type=br.BEGEMOT_FAILCACHE_HIT_RESULT,
            required=True
        )

    def on_enqueue(self):
        self.Context.diffs = br.BEGEMOT_FAILCACHE_HIT_DIFF(
            self,
            'FailCache hit diff output',
            'output.txt'
        ).id

    def parse_resource(self, path):
        with open(path, 'r') as data:
            for line in data:
                line = line.strip()
                if not line:
                    continue
                return float(line)

    def on_execute(self):
        self.Context.has_change = False
        data_path_1 = str(sdk2.ResourceData(self.Parameters.failcache_hit_1).path)
        data_path_2 = str(sdk2.ResourceData(self.Parameters.failcache_hit_2).path)
        failcache_hit_1 = self.parse_resource(data_path_1)
        failcache_hit_2 = self.parse_resource(data_path_2)
        difference = failcache_hit_1 - failcache_hit_2
        self.Context.diff_rate = abs(difference)

        output = str(sdk2.Resource[self.Context.diffs].path)
        with open(output, 'w') as output_file:
            output_file.write(str(difference))
