import os

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.sdk2.helpers.process import subprocess
from sandbox.projects.common import network
from sandbox.projects.websearch.begemot.tasks.BegemotMarkerTests.validator import run_all_tests
from sandbox.projects.websearch.begemot.resources import resource_types as br


class BegemotMarkerTests(sdk2.Task):
    """
    Run very light tests to sanity-test some begemot clients.
    These tests just reduce the probability of severe incidents.
    This is in no way quality acceptance.
    """

    class Parameters(sdk2.Task.Parameters):
        binary = sdk2.parameters.Resource('Wizard binary', resource_type=br.REMOTE_WIZARD)
        shard = sdk2.parameters.Resource('Shard', resource_type=br.WIZARD_SHARD)
        fresh = sdk2.parameters.Resource('Fresh data', resource_type=br.WIZARD_RUNTIME_PACKAGE_UNPACKED)
        config = sdk2.parameters.Resource('Wizard config', resource_type=br.WIZARD_CONFIG)

    def on_enqueue(self):
        self.Requirements.disk_space = self.Requirements.ram = (
            (self.Parameters.binary.size + self.Parameters.shard.size + self.Parameters.fresh.size) >> 20
        ) + 5 * 1024

    def on_execute(self):
        port = 8891
        host = network.get_my_ipv6()

        with sdk2.helpers.ProcessRegistry:
            data = str(sdk2.ResourceData(self.Parameters.shard).path)
            data_sym = str(self.path('wizard/WIZARD_SHARD'))
            os.makedirs('wizard')
            os.symlink(data, data_sym)
            p = subprocess.Popen([
                str(sdk2.ResourceData(self.Parameters.binary).path),
                '--data', '.',
                '--config', str(sdk2.ResourceData(self.Parameters.config).path),
                '-R', str(sdk2.ResourceData(self.Parameters.fresh).path),
                '--port', str(port),
            ], stderr=subprocess.PIPE)
            line = p.stderr.readline()
            started = False
            while line:
                if 'port {}'.format(port) in line:
                    started = True
                    break
                else:
                    self.set_info(line)
                    line = p.stderr.readline()
            if not started:
                raise TaskFailure('wizard cannot start')
            run_all_tests(host, port)
