# -*- coding: utf-8 -*-

from __future__ import print_function

import requests
import six.moves.urllib.parse as urllib
from requests.packages.urllib3.util.retry import Retry
import logging
import sys

import sys  # noqa
if sys.version_info.major < 3:
    reload(sys)
    sys.setdefaultencoding('utf8')


class Service(object):
    def __init__(self, base_url, service, validator):
        self.base_url = base_url
        self.service = service
        self.session = requests.Session()
        self.session.mount('https://', requests.adapters.HTTPAdapter(max_retries=Retry(total=10, backoff_factor=0.1)))
        self.validator = validator  # function: requests.response -> bool

    def validate(self, host, port, requests, expect_fail=False):
        success = True
        service = self.service
        logging.info('Validating {service}'.format(**locals()))
        for request in requests:
            more_cgi = ''
            if isinstance(request, tuple):
                request, more_cgi = request[0], '&' + request[1]
            request = urllib.quote(request)
            url = self.base_url.format(**locals())
            logging.debug(url)
            response = self.session.get(url)
            result = self.validator(response)
            if result is True:
                continue
            if not expect_fail:
                logging.error('Validation failed.\n  Request: {req}\n  Validation result: {result}\n  Response: {code}\n  {text}'.format(
                    req=request, result=result, code=response.status_code, text=response.text
                ))
            success = False
        success = success ^ expect_fail
        logging.info('{service} validation (expect_fail = {expect_fail}): {result}'.format(
            service=self.service, result='ok' if success else 'failed, fix required (this is not expected)', expect_fail=expect_fail
        ))
        return success


class Validators(object):
    @staticmethod
    def news(response):
        try:
            response.raise_for_status()
            for c in response.json()['items']['item']:
                if c['cluster']['found_doc_count'] > 0:
                    return True
            return False
        except Exception as x:
            return str(x)


News = Service(
    # 'https://news.stable.priemka.yandex.ru/yandsearch?'  # this is news testing, unstable, see https://st.yandex-team.ru/SPI-4319#5beab7a77c9c000136c52e49
    'https://{service}.yandex.ru/yandsearch?'
    'text={request}'
    '&rpt=nnews2&grhow=clutop&flags=yxnews_metahost='
    '{{"WIZARD":{{"host":"{host}","port":{port}}}}}'
    '&json=da{more_cgi}',
    'news',
    Validators.news
)


def run_all_tests(beta_host, beta_port):
    return all([
        # 1002 — это РИА Новости, они всегда будут
        News.validate(beta_host, beta_port, ['астероид', 'погода', 'yx_news_agency_id:"1002"']),
        #  News require ALL words in document, this request should generate empty serp
        News.validate(beta_host, beta_port, ['астероид b7a9d5ab-2dcf-4a75-8f15-75aa2a6cd414'], expect_fail=True)
    ])


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)
    print('Validation result: ', run_all_tests('manul.search.yandex.net', 47220))
