import datetime


class BegemotYtPaths(object):
    prefix = '//home/begemot'

    # last YT table path with eventlog on hahn
    @classmethod
    def get_last_eventlog_table(cls, shard='bravo', geo='sas'):
        table_name = (datetime.datetime.now() - datetime.timedelta(days=1)).strftime("%Y%m%d")
        return cls.prefix + '/eventlogdata/begemot_{}_yp_prod_{}-requests-log/'.format(shard, geo) + table_name

    @classmethod
    def get_tests_path(cls):
        return cls.prefix + '/begemot-tests'

    @classmethod
    def get_testenv_path(cls):
        return cls.get_tests_path() + '/testenv'

    @classmethod
    def get_sandbox_path(cls):
        return cls.get_tests_path() + '/sandbox'
