from sandbox import sdk2
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.common.wizard import utils as wizard_utils
from sandbox.projects.websearch.begemot import resources as br
from sandbox.projects import resource_types


class BuildBegemot(YaMakeTemplate.YaMakeTemplate):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 150 * 1024  # 150 Gb (last detected usage is 100 Mb)
        ram = 50 * 1024
        cores = 24

    class Parameters(YaMakeTemplate.get_project_params([
        br.BEGEMOT_EXECUTABLE,
        br.BEGEMOT_REQUEST_INIT_EXECUTABLE,
        br.BEGEMOT_MEGAMIND_EXECUTABLE,
        br.BEGEMOT_LOGGER_EXECUTABLE,
        br.BEGEMOT_ANTIROBOT_EXECUTABLE,
        br.BEGEMOT_GEO_EXECUTABLE,
        br.BEGEMOT_FAKESHARD_EXECUTABLE,
        br.BEGEMOT_EVLOGDUMP,
        br.BEGEMOT_EVLOGSTAT,
        br.BEGEMOT_EVLOG_UPLOADER,
        br.BEGEMOT_AH_CONVERTER,
        resource_types.UNPACKRICHTREE,
        resource_types.UNPACKREQBUNDLE,
        br.BEGEMOT_FAST_BUILD_DOWNLOADER,
        br.BEGEMOT_RESPONSE_PARSER,
        br.BEGEMOT_ARGUMENTS_PARSER,
        br.BEGEMOT_SHARD_UPDATER,
        br.BEGEMOT_YT_EVENTLOG_MAPPER,
        br.BEGEMOT_YT_MAPPER,
        br.BEGEMOT_EVLOGDUMP_FOR_UNIFIED_AGENT,
    ])):
        pass

    def on_save(self):
        wizard_utils.setup_hosts(self)
